/*
libutil -- read config file

Written by Arnt Gulbrandsen <agulbra@troll.no> and copyright 1995
Troll Tech AS, Postboks 6133 Etterstad, 0602 Oslo, Norway, fax +47
22646949.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>
and Randolf Skerka <Randolf.Skerka@gmx.de>.
Copyright of the modifications 1997.
Modified by Kent Robotti <robotti@erols.com>. Copyright of the
modifications 1998.
Modified by Markus Enzenberger <enz@cip.physik.uni-muenchen.de>.
Copyright of the modifications 1998.
Modified by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>.
Copyright of the modifications 1998, 1999.

See file COPYING for restrictions on the use of this software.
*/

#include "leafnode.h"
#include <ctype.h>
#include <errno.h>
#include <limits.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <sys/resource.h>

#define COREFILESIZE 1024*1024*4
#define TOKENSIZE 80

/*
 * misc. global variables, documented in leafnode.h
 */
time_t expire = 0;
struct expire_entry * expire_base;
int artlimit = 0;
int initiallimit = 0;
int crosspostlimit = 0;
int create_all_links = 0;
int delaybody = 0;
int debugmode = 0;	/* if 1, log lots of stuff via syslog */
int maxage = 10;
int maxlines = 0;
int minlines = 0;
int maxbytes = 0;
int timeout_long = 7;
int timeout_short = 2;
int timeout_active = 90;
char * filterfile ;
char * owndn = NULL;	/* own domain name, if you can't set a sensible one */
struct serverlist * servers = NULL;

int parse_line ( char *l, char * param, char * value ) ;

/* parse a line, destructively */
int parse_line ( char *l, char * param, char * value ) {
    char *p, *q;

    p = l;
    /* skip comments */
    q = strchr( p, '#' );
    if ( q )
       *q = '\0';
    if ( *p == 0 )
        return 0;
    if (( q = strchr( p, '=' ) ) == NULL )
	return 0;
    else
	*q++ = '\0';
    /* skipping leading blanks or tabs */
    while ( isspace((int)*p) )
	p++;
    while ( isspace((int)*q) )
	q++;
    strncpy( param, p, TOKENSIZE );
    strncpy( value, q, TOKENSIZE );
    /* now param contains the stuff before '=' and value the stuff behind it */
    if ( !(*param) || !(*value) )
	return 0;
    /* skipping trailing blanks or tabs */
    p = param + strlen(param) - 1;
    q = value + strlen(value) - 1;
    while ( isspace((int)*p) && ( p > param ) ) {
	*p = '\0';
	p--;
    }
    while ( isspace((int)*q) && ( q > value ) ) {
	*q = '\0';
	q--;
    }
    return 1;
}

/*
05/25/97 - T. Sweeney - Modified to read user name and password for AUTHINFO.
                        Security questionable as password is stored in
                        plaintext in insecure file.
*/

int readconfig( void ) {
    struct serverlist *p, *q ;
    struct rlimit corelimit ;
    struct expire_entry *ent = NULL, *prev = NULL;
    FILE * f;
    char * l;
    char * param, * value ;
    int i;

    artlimit = 0;
    param = critmalloc( TOKENSIZE, "allocating space for parsing" );
    value = critmalloc( TOKENSIZE, "allocating space for parsing" );

    sprintf( s, "%s/config", libdir );
    if ( (f=fopen( s, "r" )) == 0 ) {
        syslog( LOG_ERR, "cannot open %s", s );
	free( param );
	free( value );
	return 0;
    }
    while ( (l=getaline( f )) ) {
	if ( parse_line( l, param, value ) ) {
            if ( strcmp ( "username", param ) == 0 ) {
	        if ( p ) {
		    p->username = strdup( value );
		    if ( debugmode )
	        	syslog( LOG_DEBUG, "config: username is %s",
				p->username );
		}
		else
		    syslog( LOG_ERR, "config: no server for username %s",
			    value );
	    }
	    else if ( strcmp ( "password", param ) == 0 ) {
		if ( p ) {
		    p->password = strdup( value );
		    if ( debugmode )
			syslog( LOG_DEBUG, "config: password is %s",
				p->password);
		}
		else
		    syslog( LOG_ERR, "config: no server for password" );
	    }
	    else if ( strcmp( "timeout", param ) == 0 ) {
		if ( p ) {
		    p->timeout = atoi( value );
		    if ( debugmode )
			syslog( LOG_DEBUG, "config: timeout is %d seconds",
				p->timeout );
		}
		else
		    syslog( LOG_ERR, "config: no server for timeout" );
	    }
	    else if ( strcmp ( "create_all_links", param ) == 0 ) {
		if ( value && strlen( value ) ) {
		    create_all_links = 1;
		    if ( debugmode )
			syslog( LOG_DEBUG,
				"config: link articles in all groups" );
		}
	    }
	    else if ( strcmp ( "expire", param ) == 0 ) {
	        expire = time(NULL)-(time_t)( SECONDS_PER_DAY *atol( value ));
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: expire is %s days", value);
	    }
	    else if ( strcmp ( "filterfile", param ) == 0 ) {
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: filterfile is %s", value );
		filterfile = strdup( value );
	    }
	    else if ( strcmp ( "hostname", param ) == 0 ) {
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: hostname is %s", value );
		owndn = strdup( value );
	    }
	    else if ( ( strcmp ( "maxcrosspost", param ) == 0 ) ||
		      ( strcmp ( "maxgroups", param ) == 0 ) ) {
		/* maxgroups is for compatibility with leafnode+ */
		crosspostlimit = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: crosspostlimit is %d groups",
			    crosspostlimit );
	    }
	    else if ( strcmp( "maxlines", param ) == 0 ) {
		maxlines = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: postings have max. %d lines",
			    maxlines );
	    }
            else if ( strcmp( "minlines", param ) == 0 ) {
                minlines = atoi( value );
                if ( debugmode )
                    syslog( LOG_DEBUG, "config: postings have min. %d lines",
                            minlines );
            }
            else if ( ( strcmp( "maxbytes", param ) == 0 ) && !maxlines ) {
                maxbytes = atoi( value );
                if ( debugmode )
                    syslog( LOG_DEBUG,
			    "config: postings have max. %d bytes", maxbytes);
            }
	    else if ( strcmp( "debugmode", param ) == 0 ) {
		debugmode = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: debugmode is %d", debugmode );
	    }
	    else if ( strcmp( "delaybody", param ) == 0 ) {
		delaybody = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: delaybody is %d (default 0)",
			    delaybody );
	    }
	    else if ( strcmp( "timeout_short", param ) == 0 ) {
		timeout_short = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: timeout_short is %d days",
			    timeout_short );
	    }
	    else if ( strcmp( "timeout_long", param ) == 0 ) {
		timeout_long = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: timeout_long is %d days",
			    timeout_long );
	    }
	    else if ( strcmp( "timeout_active", param ) == 0 ) {
		timeout_active = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: timeout_active is %d days",
			    timeout_active );
	    }
	    else if ( strncmp( "groupexpire", param, 11 ) == 0 ) {
		char * m;
		m = param;
		while ( !(isspace((int)*m)) )
		    m++;
		while ( isspace((int)*m) )
		    m++;
		if ( m && *m ) {
		    i = time(NULL)-(time_t)( SECONDS_PER_DAY *atol(value));
                    ent = (struct expire_entry *)
                           malloc( sizeof(struct expire_entry) );
                    ent->group = strdup(m);
                    ent->xtime = i;
                    ent->next = prev;
                    prev = ent;
		    if ( debugmode )
		        syslog( LOG_DEBUG,
				"config: groupexpire for %s is %s days",
				m, value);
		}
            }
	    else if ( ( strcmp( "maxage", param ) == 0 ) ||
		      ( strcmp( "maxold", param ) == 0 ) ) {
		/* maxold is for compatibility with leafnode+ */
	        maxage = atoi( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: maxage is %d", maxage );
	    }
	    else if ( strcmp( "maxfetch", param ) == 0 ) {
	        artlimit = atol( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: maxfetch is %d", artlimit);
	    }
	    else if ( strcmp( "port", param ) == 0 ) {
		if ( p ) {
		    p->port = atoi ( value );
		    if ( debugmode )
			syslog( LOG_DEBUG, "config: nntpport is %d",
			p->port );
		}
		else
		    syslog( LOG_ERR, "config: no server for nntpport %s",
			    value );
	    }
	    else if ( strcmp( "nodesc", param ) == 0 ) {
		if ( p ) {
		    p->descriptions = FALSE;
		    if ( debugmode )
			syslog( LOG_DEBUG, "config: no LIST NEWSGROUPS for %s",
			p->name );
		}
		else
		    syslog( LOG_ERR, "config: no server for nodesc = %s",
			    value );
	    }
	    else if ( strcmp( "initialfetch", param ) == 0 ) {
	        initiallimit = atol ( value );
		if ( debugmode )
		    syslog( LOG_DEBUG, "config: initialfetch is %d",
			    initiallimit);
	    }
	    else if (( strcmp ( "server", param ) == 0 ) ||
		    ( strcmp ( "supplement", param ) == 0 )) {
		syslog( LOG_INFO, "config: server is %s", value );
		p = (struct serverlist *)critmalloc( sizeof(struct serverlist),
		     "allocating space for server name");
		p->name = strdup( value );
		p->descriptions = TRUE;
		p->next = NULL;
		p->timeout = 10;	/* default 10 seconds */
		p->port = 0;
		p->username = NULL;
		p->password = NULL;
		if ( servers == NULL )
		    servers = p;
		else
		    q->next = p;
		q = p;
	    }
	}
    }
    debug = debugmode;

    expire_base = ent;
    fclose(f);
    if ( servers == NULL ) {
	syslog( LOG_ERR, "no server declaration in config file");
	free( param );
	free( value );
	return 0;
    }
    if ( !expire )
	syslog( LOG_ERR, "no expire declaration in config file");
    
    if ( debugmode > 1 ) {
        corelimit.rlim_cur = COREFILESIZE;
        if ( setrlimit( RLIMIT_CORE, &corelimit ) < 0 )
            syslog( LOG_DEBUG, "Changing core file size failed: %m" );
        corelimit.rlim_cur = 0;
        getrlimit( RLIMIT_CORE, &corelimit );
        syslog( LOG_DEBUG, "Core file size: %d", corelimit.rlim_cur );
    }

    free( param );
    free( value );
    return 1;
}
