/*
 * Checkgroups: script that updates the description of newsgroups
 * Input file : a checkgroups script that contains the name of
 *              the newsgroup and its description in one line
 *
 * Written and copyrighted by Cornelius Krasel, April 1997
 * Source code borrows a lot from fetch(1).
 *
 * See file COPYING for restrictions on the use of this software.
 */

#include "leafnode.h"
#include <sys/types.h>
#include <ctype.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdlib.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

int debug = 0;
int verbose = 0;

void process_input(char *s);

void process_input(char *s) {
    FILE * f;
    char * l;
   
    f = fopen( s, "r" );
    if (!f) {
        fprintf(stderr,"%s deleted (shouldn't happen)\n",s);
        return;
    }

    while ( (l=getaline( f )) ) {
        char * p;
        struct newsgroup * g;

        p = l;
        if (isalnum((int)*p)) {
            while (!isspace((int)*p))
                p++;
            if (*p)
                *p++ = '\0';
            if ((g = findgroup(l)) != NULL) {
	        fprintf( stderr, "%s\n", l );
                if (strlen(p) > 0)
                    g->desc = strdup(p);
	    }
        }
    }

    fclose( f );
}

int main(int argc, char *argv[] ) {
    FILE * f;

    if ( ! initvars( argv[0] ) )
	exit( 1 );

    if (argc != 2) {
        fprintf( stderr, "Usage: %s [checkgroups file]\n", argv[0] );
        exit( 1 );
    }

    /* Check whether input file exists */
    if ( !( f = fopen( argv[1], "r" ))) {
        if ( errno == EACCES )
	    fprintf( stderr, "%s: not permitted to open %s\n",
		     argv[0], argv[1] );
	else
	    fprintf( stderr, "%s: checkgroups file %s doesn't exist\n",
		     argv[0], argv[1] );
        exit( 1 );
    }
    else
        fclose(f);

    whoami();
    umask(2);

    readactive();	/* read groupinfo file */
    process_input(argv[1]);
    writeactive();	/* write groupinfo file */
    exit(0);
}
