/*
libutil -- stuff dealing with articles

Written by Cornelius Krasel <krasel@wpxx02.toxi.uni-wuerzburg.de>.
Copyright 1998, 1999.

See file COPYING for restrictions on the use of this software.
*/

#include "leafnode.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/stat.h>
#include <unistd.h>

/*
 * find a header in an article and return it
 */
char * fgetheader( FILE * f, const char * header ) {
    char * hdr, *p ;
    int hlen, next;

    debug = 0;
    next = 0;
    hdr = NULL;
    p = NULL;
    hlen = strlen( header );
    while ( ( p = getaline( f )) && *p ) {	/* read only headers */
	/* allow for multiline headers */
	if ( isspace((int)*p) && hdr && next ) {
	    hdr = critrealloc( hdr, strlen( hdr ) + strlen( p ) + 2,
			     "Allocating space for multiline headers" );
	    strcat( hdr , "\n" );
	    strcat( hdr , p );
	} else if ( ( strncasecmp( p, header, hlen ) == 0 ) ) {
	    p += hlen;
	    while ( p && *p && isspace((int)*p) )
		p++;
	    hdr = strdup( p );
	    next = 1;
	} else
	    next = 0;
    }
    debug = debugmode;
    rewind( f );
    return hdr;
}

char * getheader( const char * filename, const char * header ) {
    FILE * f;
    char * hdr;
    struct stat st ;

    if ( stat( filename, &st ) || !S_ISREG( st.st_mode ) )
	return NULL;
    if ( ( f = fopen( filename, "r" ) ) == 0 )
	return NULL;
    hdr = fgetheader( f, header );
    fclose( f );
    return hdr;
}

/*
 * store article in "filename" in /var/spool/news/message.id and the
 * corresponding newsgroups. No checks are made whether the filename
 * points to a real file or a directory.
 * This code is currently unused.
 */
void storearticle ( char * filename, char * msgid, char * newsgroups ) {
    FILE * infile, * outfile;
    const char * outname ;
    char * l, * xref;
    char * p, * q;
    int  body;
    static struct newsgroup * cg;
    char tmp[ 10 ];
    char tmpxref[ 4096 ] ; /* 1024 for newsgroups, plus article numbers */

    if ( ( infile = fopen( filename, "r" ) ) == NULL )
	return;
    outname = lookup( msgid );
    if ( ( outfile = fopen( outname, "r" ) ) ) {
	/* if an article is already present, we overwrite it to create a
	   corrected Xref: line. However, we have to parse the Xref:
	   line which is already in the article because otherwise
	   we'll create double instances of articles
	 */
	xref = fgetheader( outfile, "Xref:" );
	fclose( outfile );
    } else
	xref = NULL;
    if ( ( outfile = fopen( outname, "w" ) ) == NULL )
	return;
    body = FALSE;
    while (( l = getaline( infile ) ) != NULL ) {
	if ( body || strncmp( l, "Xref:", 5 ) ) {
	    if ( ( *l == '.' ) && ( strlen( l ) == 1 ) )
		;
	    else
		fprintf( outfile, "%s\n", l );
	} else if ( strlen( l ) == 0 ) {
	    /* create Xref: line and all the links in the newsgroups */
	    p = newsgroups;
	    strcpy( tmpxref, fqdn );
	    while ( p && *p ) {
		/* somewhere in this mess we have to accommodate the
		   already existing Xref: line */
		cg = NULL;
		q = strchr( p, ',' );
		if ( q )
		    *q++ = '\0';
		if ( *p && isinteresting( p ) ) {
		    cg = findgroup( p );
		    if ( cg && chdirgroup( p, TRUE ) ) {
			do {
			    sprintf( tmp, "%d", ++cg->last );
			    errno = 0;
			} while ( link( outname, tmp )<0 && errno==EEXIST );
			if ( errno )
			    fprintf( stderr, "error linking %s into %s/%s\n",
				     outname, p, tmp );
			else if ( verbose )
			    fprintf( stderr, "storing %s as %s in %s\n",
				     outname, tmp, p );
			strcat( tmpxref, " " );
			strcat( tmpxref, p );
			strcat( tmpxref, ":" );
			strcat( tmpxref, tmp );
		    }
		}
		p = q;
	    }
	    fprintf( outfile, "\n" );
	    body = TRUE;
	}
    } /* while */
    if ( xref )
	free( xref );
    fclose( infile );
    fclose( outfile );
}

/*
 * store articles in newsgroups which are already stored in
 * $SPOOLDIR/message.id/
 */
void store( const char * filename,
	    FILE * filehandle,
	    size_t bytes,
	    char * newsgroups,
	    const char * subject,
	    const char * from,
	    const char * date,
	    const char * msgid,
	    const char * references,
	    const char * lines)
{
    char tmp[10];
    static struct newsgroup * cg;
    char xrefincase[4096]; /* 1024 for newsgroups, plus article numbers */
    char * p;
    char * q;
    char * x;

    x = xrefincase;
    if ( verbose > 2 )
	printf( "storing %s: %s\n", msgid, newsgroups );

    p = newsgroups;
    while (p && *p) {
	q = strchr( p, ',' );
	if (q)
	    *q++ = '\0';
	if ( *p ) {
	    if (!cg || strcmp(cg->name, p)) {
		cg = findgroup( p );
		if ( cg ) {
		    if ( isinteresting(cg->name) || create_all_links )
		        (void) chdirgroup( p, TRUE );
		    else
		    	cg = NULL;
		}
	    }
	    if ( cg ) {
		do {
		    sprintf(tmp, "%d", ++cg->last);
		    errno = 0;
		    if ( verbose > 2 )
			printf( "..as article %d in %s\n",
			       cg->last, cg->name );
		} while ( link( filename, tmp )<0 && errno==EEXIST );
		if ( errno )
		    syslog( LOG_ERR, "error linking %s into %s: %m",
			    filename, p );
		else {
		    sprintf( x, " %s:%d", cg->name, cg->last );
		    x += strlen( x );
		}
	    } else {
		if ( verbose > 2 )
		    printf( ".. discarding unknown group %s\n", p );
	    }
	}
	p = q;
    }
    fprintf( filehandle, "Xref: %s%s\n", fqdn, xrefincase );
}
