/* $Id: leafnode.h,v 1.9 1999/02/23 19:12:21 krasel Exp $ */

#ifndef LEAFNODE_H
#define LEAFNODE_H

/* I wish the world were a happy place */
#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

/* limits.h is supposed to contain PATH_MAX, we include sys/param.h too */
#include <limits.h>
#ifndef PATH_MAX
#include <sys/param.h>
#define PATH_MAX MAXPATHLEN
#endif

#include "config.h"	/* FreeSGI barfs on #ifdef HAVE_CONFIG_H */

#ifdef HAVE_AP_CONFIG_H
#define AP_CONFIG_H
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#include <sys/errno.h>
#endif
#ifndef HAVE_ERRNO_H
extern int errno;
#endif	/* HAVE_ERRNO_H */

#ifndef HAVE_STRDUP
char * strdup (const char *);
#endif

#ifndef HAVE_SNPRINTF
int snprintf( char *str, size_t n, const char *format, ... );
#endif

/* add LOG_NEWS where it doesn't exist */
#include <syslog.h>
#if !defined( LOG_NEWS )
#define LOG_NEWS LOG_DAEMON
#endif
#if !defined( LOG_CONS )
#define LOG_CONS 0 /* if it isn't supported, make do without */
#endif

#include <sys/types.h>	/* for regex.h */
#include <regex.h> /* regex_t */
#include <stdio.h> /* FILE * */
#include <time.h>  /* time_t */

#define SECONDS_PER_DAY ( 24 * 60 * 60 )

/* Limit on the number of message bodies marked for download per group. */
#define BODY_DOWNLOAD_LIMIT 2048

/* initialize global variables */
int initvars( char * progname );

/* converts a message-id to a file name, the return value points into
   a static array */
const char * lookup ( const char *msgid );

char * getaline(FILE *f);	/* reads one line, regardless of length */
char * tgetaline( FILE *f );	/* read line with timer */

/* changes (and optionally creates) directory */
int chdirgroup(const char *group, int creatdir);

/*
 * newsgroup management
 */
struct newsgroup {
    unsigned long first;
    unsigned long last;
    int alive;
    char * name;
    char * desc;
    time_t age;
};

int isinteresting( const char * groupname );
void insertgroup(const char * name, long unsigned first, long unsigned last,
   int date );
void changegroupdesc( const char * groupname, char * description );
void mergegroups( void );
struct newsgroup * findgroup( const char* name );
void readactive( void );
void writeactive( void );
void fakeactive( void );

extern struct newsgroup * active;

/* translation from message-id to article number, used in fetch and expire */

void clearidtree( void );
void insertmsgid( const char * msgid, int art );
int findmsgid( const char* msgid );

/* -----------here starts the new stuff-----------------*/

/*
 * a linear list of strings
 */
struct stringlist {
    struct stringlist * next;
    char string[1] ;
};

void appendtolist( struct stringlist ** list, struct stringlist ** lastentry,
    char * newentry ) ;
char * findinlist( struct stringlist * haystack, char * needle ) ;
	/* find a string in a stringlist by doing a linear search */
void freelist( struct stringlist * list ) ;
	/* free memory occupied by a stringlist */
	
/*
 * filtering headers for regexp
 */
void readfilter( char *filterfile ) ;
int dofilter( char * h ) ;

/*
 * artutil -- handling article files
 */

/*
 * store articles
 */
void storearticle ( char * filename, char * msgid, char * newsgroups ) ;
void store( const char * filename,
	    FILE * filehandle,
	    const size_t bytes,
	    char * newsgroups,
	    const char * subject,
	    const char * from,
	    const char * date,
	    const char * msgid,
	    const char * references,
	    const char * lines);

/*
 * find a certain header in an article and return it
 */
char * getheader( const char * filename, const char * header );
char * fgetheader( FILE *f, const char * header );

/*
 * xover stuff -- for nntpd.c
 */
struct xoverinfo {
    char * text;
    int mallocd;
    int exists;
};

extern struct xoverinfo * xoverinfo;
extern long xfirst;
extern long xlast;

int getxover( void );	/* set xoverinfo, return 0 on error, nonzero else */

/*
 * the strings in config.c
 */
extern const char * spooldir;
extern const char * libdir;
extern const char * bindir;
extern const char * version;
extern const char * lockfile;

/*
 * global variables from config file. These are defined in configutil.c
 */
struct expire_entry {
    int xtime;
    struct expire_entry *next;
    char * group;
};

struct serverlist {
    int port ;
    int descriptions ;		/* download descriptions as well */
    int timeout ;		/* timeout in seconds before we give up */
    struct serverlist * next;
    char * name ;		/* Servername */
    char * username ;
    char * password ;
};

extern time_t expire;	/* articles not touched since this time get deleted */
extern struct expire_entry * expire_base;
			/* expire for certain groups */
extern int artlimit;	/* max # of articles to read per group in one go */
extern int initiallimit;
			/* max # of articles to read at first time */
extern int crosspostlimit;
			/* crossposting limit, to reduce spam */
extern int delaybody;	/* delay download of message body */
extern int debugmode;	/* log lots of stuff via syslog */
extern int create_all_links;
			/* store articles even in uninteresting groups */
extern int maxage;	/* max age of articles */
extern int maxlines;	/* max length of articles in lines */
extern int minlines;	/* min length of articles in lines */
extern int maxbytes;	/* max length of articles in bytes */
extern int timeout_short;	/* don't fetch groups that have been
				   accidentally accessed after that many days */
extern int timeout_long;	/* don't fetch groups that have been accessed
				   that many days */
extern int timeout_active;	/* reread active file after that many days */
extern char * filterfile;	/* filename where filter resides */
extern char * owndn;		/* own domain name, if you can't set one */
extern struct serverlist * servers;
			/* list of servers to use */

/*
 * other global variables
 */
extern char last_command[1025];
extern char lineout[1025];

/* defined in nntputil.c */
extern FILE *nntpin;
extern FILE *nntpout;

extern char s[];
extern char fqdn[];		/* my name, and my naming myself */

extern int verbose;		/* verbosity level, for fetch and texpire */
extern int debug;		/* debug level */

/*
 * misc prototypes
 */
int lockfile_exists( void );
void putaline( void );
void retry( void );
void readexpire( void );
void free_expire( void );
int readconfig( void );
void whoami( void );
void lowercase( char *string );
char * critmalloc(size_t size, const char* message);
char * critrealloc(char *a, size_t size, const char* message);
int ngmatch(const char* pattern, const char* string);

int rename(const char *old, const char *new);
				/* to avoid barfing of Digital Unix */

/*
 * stuff from nntputil.c
 */
int authenticate( void );	/* authenticate ourselves at a server */
int nntpreply( void );		/* decode an NNTP reply number */
int nntpconnect( const struct serverlist * upstream );
				/* connect to upstream server */
void nntpdisconnect( void );	/* disconnect from upstream server */

const char* rfctime(void);	/* An rfc type date */

#endif	/* #ifndef LEAFNODE_H */
