/***************************************************************************
                          shots.c  -  description
                             -------------------
    begin                : Sat Sep 8 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lbreakout.h"
#include "config.h"
#include "list.h"
#include "levels.h"
#include "shrapnells.h"
#include "bricks.h"
#include "shots.h"
#ifdef SOUND
#include "audio.h"
#endif

extern SDL_Surface *shot_pic;
extern SDL_Surface *shot_shadow;
List *shots; /* list of all shots */
int shot_w = 10;
int shot_h = 10;
int shot_fr_num = 4;
float shot_fpms = 0.01;
float shot_v_y = -0.2;
int shot_alpha = 64;
int shot_limit = 10; /* maximimum number of shots */
int shot_bricks_hit = 0, shot_mx, shot_my; /* how many bricks destroyed by shot at position mx, my */
extern Brick bricks[MAP_WIDTH][MAP_HEIGHT];
extern SDL_Surface *offscreen;
extern Sdl sdl;
extern int shadow_size;
extern Config config;
#ifdef SOUND
extern Sound_Chunk *wav_shot;
#endif

/*
====================================================================
Locals
====================================================================
*/

/*
====================================================================
Compute target of shot.
====================================================================
*/
void shot_get_target( Shot *shot ) {
    int mx = (int)(shot->x + 3) / BRICK_WIDTH;
    int my = (int)(shot->y + 3) / BRICK_HEIGHT;
    memset(&shot->t, 0, sizeof(Target));
    while (bricks[mx][my].id == -1) my--;
    shot->t.mx = mx; shot->t.my = my;
    mx = (int)(shot->x + 6) / BRICK_WIDTH;
    if (mx != shot->t.mx) {
        my = (int)(shot->y + 3) / BRICK_HEIGHT;
        while(bricks[mx][my].id == -1) my--;
        if (my > shot->t.my) {
            shot->t.mx = mx;
            shot->t.my = my;
            shot->next_too = 0;
        }
        else
            if (my == shot->t.my)
                shot->next_too = 1;
    }
    shot->t.cur_tm = 0;
    shot->t.time = (int)((shot->y + 3 - (shot->t.my * BRICK_HEIGHT + BRICK_HEIGHT - 1)) / fabs(shot_v_y));
}

/*
====================================================================
Publics
====================================================================
*/

/*
====================================================================
Load, delete shot graphics
====================================================================
*/
void shot_load()
{
    shots = list_create( LIST_AUTO_DELETE, NO_CALLBACK );
}
void shot_delete()
{
    if ( shots ) list_delete( shots ); shots = 0;
}
/*
====================================================================
Create new shot at position (centered)
====================================================================
*/
void shot_create( int x, int y )
{
    Shot *shot = calloc( 1, sizeof( Shot ) );
    shot->cur_fr = 0;
    shot->x = x - (shot_w >> 1);
    shot->y = y - (shot_h >> 1);
    shot_get_target( shot );
    list_add( shots, shot );
#ifdef SOUND
    sound_play( wav_shot );
#endif
}
/*
====================================================================
Delete all shots
====================================================================
*/
void shots_reset()
{
    list_clear( shots );
}
/*
====================================================================
Hide and show shots
====================================================================
*/
void shots_hide()
{
    List_Entry  *entry = shots->head.next;
    Shot        *shot;
    int w = shot_w, h = shot_h;
    if ( config.shadow ) { w += shadow_size; h += shadow_size; }
    while ( entry != &shots->tail ) {
        shot = entry->item;
        DEST(sdl.screen, (int)shot->x, (int)shot->y, w, h );
        SOURCE(offscreen, (int)shot->x, (int)shot->y);
        blit_surf();
        add_refresh_rect((int)shot->x, (int)shot->y, w, h );
        entry = entry->next;
    }
}
void shots_show()
{
    List_Entry  *entry = shots->head.next;
    Shot        *shot;
    if ( config.shadow ) set_surf_clip( sdl.screen, 0, 0, sdl.screen->w - BRICK_WIDTH, sdl.screen->h );
    while ( entry != &shots->tail ) {
        shot = entry->item;
        if ( config.shadow ) {
            DEST(sdl.screen, (int)shot->x + shadow_size, (int)shot->y + shadow_size, shot_w, shot_h);
            SOURCE(shot_shadow, 0, 0);
            alpha_blit_surf(SHADOW_ALPHA);
        }
        DEST(sdl.screen, (int)shot->x, (int)shot->y, shot_w, shot_h);
        SOURCE(shot_pic, (int)shot->cur_fr * shot_w, 0);
        alpha_blit_surf(shot_alpha);
        if ( config.shadow )
            add_refresh_rect((int)shot->x, (int)shot->y, shot_w + shadow_size, shot_h + shadow_size);
        else
            add_refresh_rect((int)shot->x, (int)shot->y, shot_w, shot_h);
        entry = entry->next;
    }
    if ( config.shadow ) set_surf_clip( sdl.screen, 0, 0, 0, 0 );
}
void shots_alphashow( int alpha )
{
    List_Entry  *entry = shots->head.next;
    Shot        *shot;
    while ( entry != &shots->tail ) {
        shot = entry->item;
        DEST(sdl.screen, (int)shot->x, (int)shot->y, shot_w, shot_h);
        SOURCE(shot_pic, (int)shot->cur_fr * shot_w, 0);
        alpha_blit_surf(alpha);
        add_refresh_rect((int)shot->x, (int)shot->y, shot_w, shot_h);
        entry = entry->next;
    }
}
/*
====================================================================
Update position of shots and check if bricks get destroyed
If this happens true is returned and balls must be checked (new
targets).
====================================================================
*/
int shots_update( int ms )
{
    int         result = 0;
    List_Entry  *entry = shots->head.next;
    Shot        *shot;
    while ( entry != &shots->tail ) {
        shot = entry->item;
        shot->cur_fr += ms * shot_fpms;
        if (shot->cur_fr >= shot_fr_num) shot->cur_fr -= shot_fr_num;
        shot->y += ms * shot_v_y;
        shot->t.cur_tm += ms;
        entry = entry->next;
        if (shot->t.cur_tm > shot->t.time) {
            if ( brick_hit(shot->t.mx, shot->t.my, 0, SHR_BY_SHOT, vector_get( 0, 1 ) ) ) {
                shot_bricks_hit++;
                shot_my = shot->t.my;
                shot_mx = shot->t.mx;
            }
            if (shot->next_too) {
                if ( brick_hit(shot->t.mx + 1, shot->t.my, 0, SHR_BY_SHOT, vector_get( 0, 1 ) ) ) shot_bricks_hit++;
                shots_get_new_targets(shot->t.mx + 1, shot->t.my);
            }
            shots_get_new_targets(shot->t.mx, shot->t.my);
            list_delete_entry( shots, entry->prev );
            result = 1;
        }
    }
    return result;
}
/*
====================================================================
Get new targets for all shots that where supposed to
destroy brick at x,y
====================================================================
*/
void shots_get_new_targets( int x, int y )
{
    Shot        *shot;
    list_reset( shots );
    while ( ( shot = list_next( shots ) ) )
        if (shot->t.mx == x && shot->t.my == y)
            shot_get_target( shot );
}
/*
====================================================================
Return true if below shot_limit
====================================================================
*/
int shots_below_limit()
{
    return shot_limit - shots->count;
}
