/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	NJN
 *
 *	$Id: mpil_spawn_f.c,v 6.4.2.2 2002/10/09 19:49:34 brbarret Exp $
 *
 *	Function:	- MPIL_Spawn, MPIL_Comm_parent,	MPIL_Universe_size
 *			  F77 wrappers
 */

#include <lam_config.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>


void
mpil_spawn_(c, a, r, ic, ierr)

int	*c, *r,	*ic, *ierr;
char	*a;

{
	MPI_Comm comm;

	*ierr =	MPIL_Spawn(GETHDL(*c), a, *r, &comm);
	
	if (lam_F_make_hdl(ic, ierr, comm, BLKMPILSPAWN)) {
		comm->c_f77handle = *ic;
	}
}


void
mpil_comm_parent_(c, ierr)

int	*c, *ierr;

{
	MPI_Comm	parent;

	*c = -1;
	*ierr = MPIL_Comm_parent(&parent);

	if (*ierr == MPI_SUCCESS && parent != LAM_MPI_C_COMM_NULL) {
		if (parent->c_f77handle < 0) {
			lam_F_make_hdl(c, ierr, parent, BLKMPILCOMMPARENT);
			parent->c_f77handle = *c;
		} else {
			*c = parent->c_f77handle;
		}
	}
}


void 
mpil_universe_size_(s, ierr)

int	*s, *ierr;

{
	*ierr =	MPIL_Universe_size(s);
}
