/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *
 *	$Id: etc_misc.h,v 1.5.2.1 2002/10/09 19:48:59 brbarret Exp $
 *
 *	Function:	- some radom C declarations for internal LAM functions
 */

#ifndef _LAM_ETC_MISC_H_
#define _LAM_ETC_MISC_H_

#include <portable.h>

/*
 * share/etc/show_version.c
 */
void lam_show_version(int verbose);

/*
 * share/etc/few.c
 */
int _lam_few(char *argv[]);

/*
 * share/etc/bootsockio.h
 */
int readsockint4(int sock, int4 *pdata);
int writesockint4(int sock, int4 data);
int readcltcoord(int sock, int4 *pstrport, int4 *pudpport);
int writecltcoord(int sock, int4 strport, int4 udpport);
int readcltnbr(int sock, int4 *plink, unsigned char *phostaddr,
	       int4 *pport, int4 *pnum_cpus);
int writecltnbr(int sock, int4 link, unsigned char *hostaddr,
		int4 port, int4 num_cpus);

/*
 * share/etc/nodespin.c
 */
void nodespin_init(char *msg);
void nodespin_next(int4 node);
void nodespin_end(void);

/*
 * share/etc/prime.c
 */
int is_prime(int4 n);
int4 next_prime(int4 n);


#endif
