/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *
 *	Copyright 1995 The Ohio State University
 *	$Id: nodespin.c,v 6.4.2.1 2002/10/09 19:48:52 brbarret Exp $
 *
 *	Function:	- pretty prints successive node ID messages
 */

#include <stdio.h>

#include <args.h>
#include <portable.h>

/*
 *	nodespin_init
 *
 *	Function:	- prints initial message
 *	Accepts:	- message
 */
void
nodespin_init(char *msg)
{
  printf("%s           ", msg);
}

/*
 *	nodespin_next
 *
 *	Function:	- prints next node ID
 *	Accepts:	- node ID
 */
void
nodespin_next(int4 node)
{
  char buf[16];

  sprintf(buf, "%s...", nid_fmt(node));
  printf("%-10.10s", buf);
  fflush(stdout);
}

/*
 *	nodespin_end
 *
 *	Function:	- completes node message
 */
void
nodespin_end(void)
{
  printf("%-10.10s\n", "done");
}
