/*
 * Copyright (c) 2001-2002 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: di_bootcmd.c,v 6.8.2.1 2002/10/09 19:48:41 brbarret Exp $
 *
 *	Function:	- obtains link information from command line
 *	Accepts:	- link array (value returned)
 *			- link array size (value returned)
 *			- argument vector length
 *			- argument vector
 */

#include <lam_config.h>
#include <sfh.h>

#include <netdb.h>			/* Solaris MAXHOSTNAMELEN */
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <args.h>
#include <dl_inet.h>
#include <laminternal.h>
#include <terror.h>
#include <typical.h>


/*
 * local variables
 */
static char		my_hname[MAXHOSTNAMELEN + 1];

int
di_bootcmd(pdilinks, pncpus, pndil, argc, argv)

struct dilink		**pdilinks;
int4			**pncpus;
int4			*pndil;
int			argc;
char			**argv;

{
	int		dli_port;	/* datalink input port */
	int		dli_sd;		/* datalink input socket */
	int4		i;
	int4		my_link;	/* my datalink # */
	int4		my_ncpus;	/* my number of CPUs */
	int4		ngbr_link;	/* neighbour link # */
	unsigned char	ngbr_haddr[4];	/* neighbour host address */
	unsigned char	my_haddr[4];	/* my host address */

	if ((argc % 2) != 0) {
		errno = EUSAGE;
		lampanic("dli_inet: <host>, <link> go in pairs");
	}
/*
 * Get my dli port number.
 */
	if (opt_taken('p')) {
		intparam('p', &dli_port);
	} else {
		dli_port = DLDEFPORT;
	}
/*
 * Create the inter-node communication socket.
 */
	if ((dli_sd = sfh_sock_open_srv_inet_dgm(&dli_port)) < 0) {
		lampanic("dli_inet (sfh_sock_open_srv_inet_dgm)");
	}

	if (sfh_sock_set_buf_size(dli_sd, SFH_INET, SO_RCVBUF, 
	    		sizeof(struct dlframe) * DOMAXPENDING)) {
		lampanic("dli_inet (sfh_sock_set_buf_size)");
	}
/*
 * Get my link #.
 */
	if (opt_taken('n')) {
		intparam('n', &my_link);
	} else {
		my_link = 0;
	}
/*
 * Get my number of CPUs
 */
	if (opt_taken('c')) {
		intparam('c', &my_ncpus);
	} else {
		my_ncpus = 1;
	}
/*
 * Get my host network address.
 */
	if (gethostname(my_hname, MAXHOSTNAMELEN + 1)) {
		lampanic("dli_inet (gethostname)");
	}

	if (getinetaddr(my_hname, my_haddr)) {
		lampanic("dli_inet (getinetaddr)");
	}

	*pndil = 0;

	for (i = 1; i < argc; i += 2) {
		*pndil = LAM_max(atoi(argv[i]), *pndil);
	}

	*pndil = LAM_max(my_link, *pndil);
	(*pndil)++;
/*
 * Create the links array.
 */
	*pdilinks = (struct dilink *) malloc((unsigned) *pndil *
			sizeof(struct dilink));
	if (*pdilinks == 0) 
	  lampanic("dli_inet (malloc)");
	*pncpus = (int *) malloc((unsigned) *pndil * sizeof(int));
	if (*pncpus == 0)
	  lampanic("dli_inet (malloc)");
/*
 * Init all entries to invalid link.
 */
	for (i = 0; i < *pndil; ++i) {
		(*pdilinks)[i].dil_link = NOTLINKID;
		(*pdilinks)[i].dil_seqrecv = 0;
	}
/*
 * Parse active link information off the command line.
 */
	for (i = 0; i < (argc / 2); ++i) {
		if (getinetaddr(*argv++, ngbr_haddr))
				lampanic("dli_inet (getinetaddr)");
		ngbr_link = atoi(*argv++);

		if ((ngbr_link < 0) || (ngbr_link >= *pndil)) {
			errno = EBADLINK;
			lampanic("dli_inet");
		}

		(*pdilinks)[ngbr_link].dil_link = ngbr_link;
		sfh_sock_fill_inet_addr(ngbr_haddr, (int) dli_port,
				&((*pdilinks)[ngbr_link].dil_addr));

		(*pncpus)[ngbr_link] = atoi(*argv++);
	}
/*
 * Set my link.
 */
	(*pdilinks)[my_link].dil_link = my_link;
	(*pncpus)[my_link] = my_ncpus;
	sfh_sock_fill_inet_addr(my_haddr, (int) dli_port,
			&((*pdilinks)[my_link].dil_addr));

	return(dli_sd);
}
