// $Id: send.cc,v 1.1.1.1.2.1 2001/10/29 04:32:58 bbarrett Exp $
//
// Copyright 1997-2001, University of Notre Dame.
// Authors: Jeffrey M. Squyres, Jeremy G. Siek, Michael P. McNally, and
//          Andrew Lumsdaine
// 
// This file is part of the Notre Dame C++ bindings for MPI.
// 
// You should have received a copy of the License Agreement for the Notre
// Dame C++ bindings for MPI along with the software; see the file
// LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN 46556.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted subject to the conditions specified in the
// LICENSE file.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
// 
// Additional copyrights may follow.
//

#include "mpi2c++_test.h"

void
send()
{
  char msg[150];
  int data;
  int i;
  int source;
  int tag;
  MPI::Status status;

  Testing("Send / Recv w/ Status");

  if(my_rank > 0) {
    data = my_rank;
    MPI::COMM_WORLD.Send(&data, 1, MPI::INT, 0, my_rank);
  } else {
    for(i = 1; i < comm_size; i++)  {
      data = -1;

      MPI::COMM_WORLD.Recv(&data, 1, MPI::INT, i, i, status);
      if(data != i) {
	sprintf(msg, "NODE %d - 1) ERROR in MPI::Recv, data = %d, should be %d",
		my_rank, data, i);
	Fail(msg);
      }

      source = status.Get_source();
      if(source != i) {
	sprintf(msg, "NODE %d - 2) ERROR in MPI::Recv, source = %d, should be %d",
		my_rank, source, i);
	Fail(msg);
      }
      
      tag = status.Get_tag();
      if(tag != i) {
	sprintf(msg, "NODE %d - 3) ERROR in MPI::Recv, tag = %d, should be %d",
		my_rank, tag, i);
	Fail(msg);
      }
    }
  }

  Pass(); // Send / Recv w/ Status

  MPI::COMM_WORLD.Barrier();

  Testing("Send / Recv w/o Status");

  if(my_rank) {
    data = my_rank;
    MPI::COMM_WORLD.Send(&data, 1, MPI::INT, 0, my_rank);
  } else {
    for(i = 1; i < comm_size; i++)  {
      data = -1;

      MPI::COMM_WORLD.Recv(&data, 1, MPI::INT, i, i);
      if(data != i) {
	sprintf(msg, "NODE %d - 5) ERROR in MPI::Recv, data = %d, should be %d",
		my_rank, data, i);
	Fail(msg);
      }
    }
  }
  
  Pass(); // Send / Recv w/o Status
}


