dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2002 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_get_alignment_cache.m4,v 1.1.2.2 2002/10/09 19:48:24 brbarret Exp $
dnl

define(LAM_GET_ALIGNMENT_CACHE,[
# Determine datatype alignment. 
# First arg is type, 2nd arg is cache var, 3rd arg is config var to define.
AC_CACHE_CHECK(alignment of $1,$2,[
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
struct foo { char c; $1 x; };
int main(int argc, char* argv[])
{
    struct foo *p = (struct foo *) malloc(sizeof(struct foo));
    int diff;
    FILE *f=fopen("conftestval", "w");
    if (!f) return 1;
    diff = ((char *)&p->x) - ((char *)&p->c);
    fprintf(f, "%d\n", (diff >= 0) ? diff : -diff);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    $2=`cat conftestval`
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])
AC_DEFINE_UNQUOTED($3,[$]$2)])dnl
