/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *
 *	$Id: tfseek.c,v 6.3 1999/05/27 20:07:07 kmeyer1 Exp $
 *
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <errno.h>

#include <laminternal.h>
#include <tstdio.h>


long
tftell(fp)
	TFILE *fp;
{
	long rv;

	tfflush(fp);
	rv = (long) lam_iomap_lseek(fp->_flag, fp->_file, (long) 0, SEEK_CUR);
	return((rv < 0) ? ((errno = ((int) rv)), (-1)) : rv);
}

int
tfseek(fp, offset, origin)
	TFILE *fp;
	long offset;
	int origin;
{
	long rv;

	tfflush(fp);
	rv = (long) lam_iomap_lseek(fp->_flag, fp->_file, offset, origin);
	return((rv < 0) ? ((errno = ((int) rv)), (-1)) : 0);
}

void
trewind(fp)
	TFILE *fp;
{
	long rv;

	tfflush(fp);
	rv = (long) lam_iomap_lseek(fp->_flag, fp->_file, (long) 0, SEEK_SET);
	if(rv < 0)
		errno = ((int) rv);
	fp->_flag &= ~(_TIOEOF|_TIOERR);
}
