/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *
 *	$Id: tfputc.c,v 6.3 1999/05/27 20:07:07 kmeyer1 Exp $
 * 
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * MB: added call to atkexit() 891012
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

/*
 * the CRLF --> \n translation left in case we ever go back to MS-DOS
 */

#include <kreq.h>
#include <laminternal.h>
#include <tstdio.h>

/*
 * external variables
 */
extern int _ioexit;

int
tfputc(c, fp)
	int c;
	TFILE *fp;
{
	int f, m, nl = 0;

	if (! _ioexit) {
		if (atkexit (tfcloseall, (char *) 0) != 0)
			return (EOF);
		_ioexit = 1;
	}

	f = (fp->_flag |= _TIORW);
	if(!(f & _TIOWRT)			/* not opened for write? */
	|| (f & (_TIOERR | _TIOEOF)))		/* error/eof conditions? */
		return(EOF);
	if(fp->_base == NULL)	/* allocate a buffer if there wasn't one */
		_getbuf(fp);
	if(!(f & _TIOBIN) && (c == '\n'))	/* NL -> CR+LF ? */
	{
#ifdef	DOS
		c = '\r';
		nl = 1;
#endif
	}
_fputc:
	*(fp->_ptr)++ = c;
	if (((++(fp->_cnt)) >= fp->_bsiz)
	||  (c == '\n' && (f & _TIOLBF)))	/* - MB: added */
	{
		m = fp->_cnt;			/* MB: may be < _bsiz */
		fp->_cnt = 0;
		fp->_ptr = fp->_base;
		if((lam_iomap_write(f,
				fp->_file,
				(char *) fp->_base,
				(long) m)) != m)
		{
			fp->_flag |= _TIOERR;
			return(EOF);
		}
	}
	if(nl && (c == '\r'))			/* NL -> CR+LF ? */
	{
		c = '\n';
		goto _fputc;
	}
	return(c);
}
