/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: rtrsimplex.c,v 6.3 1999/05/26 21:50:03 kmeyer1 Exp $
 *
 *	Function:	- simple traced requests
 */

#include <events.h>
#include <net.h>
#include <trreq.h>

/*
 *	lam_rtrsweep
 *
 *	Function:	- sweeps out traced's stored trace data
 *			- no reply from traced
 *	Accepts:	- target node ID
 *			- list number
 *	Returns:	- return value of nsend()
 */
int
lam_rtrsweep(nodeid, lnum)

int4			nodeid;
int4			lnum;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQSWEEP;
	request->trq_lnum = lnum;
 	request->trq_pid = TRANYPID;
	
	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*
 *	lam_rtrudie
 *
 *	Function:	- removes pid related information
 *			- no reply from traced
 *	Accepts:	- target node ID
 *			- pid
 *	Returns:	- return value of nsend()
 */
int
lam_rtrudie(nodeid, pid)

int4			nodeid;
int4			pid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQUDIE;
	request->trq_pid = pid;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*
 *	lam_rtrwipe
 *
 *	Function:	- resets traced
 *			- no reply from traced
 *	Accepts:	- target node ID
 *	Returns:	- return value of nsend()
 */
int
lam_rtrwipe(nodeid)

int4			nodeid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQWIPE;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*
 *	lam_rtrcleanobjs
 *
 *	Function:	- makes traced clean up registered objects
 *			- no reply from traced
 *	Accepts:	- target node ID
 *	Returns:	- return value of nsend()
 */
int
lam_rtrcleanobjs(nodeid)

int4			nodeid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQCLEANOBJS;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}
