/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: recho.c,v 6.3 1999/05/26 21:50:00 kmeyer1 Exp $
 *
 *	Function:	- echoes a message to/from a remote node
 *	Accepts:	- remote node
 *			- outgoing message pointer
 *			- imcoming message pointer
 *			- outgoing message length
 *	Returns:	- incoming message length
 */

#include <ereq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <portable.h>
#include <rreq.h>
#include <terror.h>
#include <typical.h>

#include <unistd.h>

int
recho(node, src_msg, dest_msg, length)

int4			node;			/* destination node */
CONST char		*src_msg;		/* ptr to source message */
char			*dest_msg;		/* echo message here */
int4			length;			/* length of echo message */

{
	struct nmsg	nhead;			/* message descriptor */
	struct ereq	*request;		/* echo request */
	int		mask;
/*
 * Check sanity on the length field.
 */
	if ((length < 0) || (length > MAXNMSGLEN)) {
		errno = EMSGLEN;
		return(ERROR);
	}
/*
 * Fill in echod request.
 */
	request = (struct ereq *) nhead.nh_data;
	request->eq_event = -getpid();
	request->eq_node = ((node == LOCAL) || (getrtype(node) & NT_CAST)) ?
			node : getnodeid();
	
	nhead.nh_node = node;
	nhead.nh_length = length;
	nhead.nh_event = EVECHOD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = (char *) src_msg;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));
/*
 * Send request to the echo daemon.
 */
	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_msg = dest_msg;
	nhead.nh_length = length;
/*
 * Received echoed message.
 */
	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);
	return(nhead.nh_length);
}
