/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: rbflook.c,v 6.3 1999/05/26 21:49:59 kmeyer1 Exp $
 * 
 *	Function:	- receives a copy of a buffered network packet
 *	Accepts:	- server node
 *			- network message descriptor
 *			- sequence #
 *	Returns:	- 0 or ERROR
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <bfreq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

int
rbflook(node, pnh_look, seq)

int4			node;
struct nmsg		*pnh_look;
int4			seq;

{
	struct bfreq	*pbfq;		/* bufferd request */
	struct bfreply	*pbfr;		/* bufferd reply */
	struct nmsg	nhbf;		/* bufferd message */
	int4		mask;		/* signal mask */
/*
 * Send a query message to the buffer.
 */
	pbfq = (struct bfreq *) nhbf.nh_data;

	pbfq->bfq_req = BFQLOOK;
	pbfq->bfq_src_node = (node == LOCAL) ? node : getnodeid();
	pbfq->bfq_src_event = -getpid();
	pbfq->bfq_seq = seq;

	nhbf.nh_dl_event = EVBUFFERD;
	nhbf.nh_node = node;
	nhbf.nh_event = EVBUFFERD;
	nhbf.nh_type = DLCTL;
	nhbf.nh_flags = 0;
	nhbf.nh_length = 0;
	nhbf.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhbf)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhbf.nh_event = -getpid();
	nhbf.nh_type = pnh_look->nh_type;
	nhbf.nh_length = 0;
	nhbf.nh_msg = 0;

	if (nrecv(&nhbf)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	pbfr = (struct bfreply *) nhbf.nh_data;

	if (pbfr->bfr_reply) {
		errno = pbfr->bfr_reply;
		ksigsetmask(mask);
		return(ERROR);
	}

	pnh_look->nh_type = pbfr->bfr_type;

	nhbf.nh_type = pnh_look->nh_type;
	nhbf.nh_length = pnh_look->nh_length;
	nhbf.nh_msg = pnh_look->nh_msg;

	if (nrecv(&nhbf)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);

	pnh_look->nh_length = nhbf.nh_length;
	memcpy((char *) pnh_look->nh_data, (char *) nhbf.nh_data,
			NHDSIZE * sizeof(int4));
	return(0);
}
