/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *      $Id: lpattach.c,v 1.1 2000/02/08 10:17:42 jsquyres Exp $
 *
 *	Function:	- registers with kenyad
 *	Accepts:	- name of program
 *	Returns:	- 0 or ERROR
 */

#include <lam_config.h>

#include <string.h>

#include <events.h>
#include <ksignal.h>
#include <kio.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>
#include <terror.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* Kernel Input/Output */

/*
 * external functions
 */
extern int4		kpgetpid();

int
lpattach(name)

CONST char		*name;

{
	struct nmsg	nhead;		/* network message */
	struct preq	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */
	int		mask;

	LAM_ZERO_ME(request);
	LAM_ZERO_ME(nhead);

	request.pq_src_node = ltot(LOCAL);
	request.pq_src_event = ltot((int4) -kbgetpid());
	request.pq_req = ltot(PQATTACH);
	request.pq_pid = ltot((int4) kbgetpid());
	request.pq_rtf = ltot(_kio.ki_rtf);

	if (name == 0) {
		request.pq_name[0] = '\0';
	} else {
		strncpy(request.pq_name, name, PSMAXNAME);
		request.pq_name[PSMAXNAME - 1] = '\0';
	}

	nhead.nh_node = LOCAL;
	nhead.nh_event = EVKENYAD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(request);
	nhead.nh_msg = (char *) &request;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -kbgetpid();
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(reply);
	nhead.nh_msg = (char *) &reply;

/*
 *	if (nrecv(&nhead)) {
 *		ksigsetmask(mask);
 *		return(ERROR);
 *	}
 */

	ksigsetmask(mask);

/*
 *	if (reply.pr_reply) {
 *		errno = ttol(reply.pr_reply);
 *		return(ERROR);
 *	} else {
 */
		_kio.ki_rtf |= RTF_KENYA;
		return(0);
/*
 *	}
 */
}
