/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: tcp_low.h,v 1.1 2001/01/10 20:00:32 jsquyres Exp $
 *
 *	Function:	- TCP client-to-client interface header
 */

#ifndef _TCP_LOW_H
#define _TCP_LOW_H

/*
 * public functions
 */
int			_tcp_advmultiple(void);
int			_tcp_adv1(void);
int			_tcp_proc_read_env(struct c2c_proc *ps);
int			_tcp_req_send_long(struct c2c_proc *ps,
					   MPI_Request req);
int			_tcp_req_send_short(struct c2c_proc *ps,
					    MPI_Request req);
int			_tcp_req_send_synch(struct c2c_proc *ps,
					    MPI_Request req);
int			_tcp_req_recv(struct c2c_proc *ps,
				      MPI_Request req);
int			_tcp_req_probe(struct c2c_proc *ps,
				       MPI_Request req);
int			_tcp_buffered_adv(MPI_Request req,
					  struct cbuf_msg *msg);
int			_tcp_fastsend(char *buf,
				      int  size,
				      struct c2c_proc *ps,
				      int dest,
				      int tag,
				      MPI_Comm comm);
int			_tcp_fastrecv(char *buf,
				      int *size,
				      struct c2c_proc *ps,
				      int src,
				      int *tag,
				      MPI_Comm comm,
				      int *seqnum);

/*
 * public variables
 */
extern int			_tcp_nio;	/* # processes doing tcp io */
extern int			_tcp_sockmax;	/* max. tcp io socket num. */
extern fd_set			_tcp_read;	/* read sockets */
extern fd_set			_tcp_write;	/* write sockets */
extern fd_set			_tcp_except;	/* exception sockets */
extern fd_set			_tcp_block;	/* blocked mode socket? */
extern fd_set			_tcp_eoferr;	/* eof on socket is error? */
extern MPI_Request		_tcp_lastreq;	/* last tcp request */
extern struct c2c_proc		*_tcp_smap[FD_SETSIZE];	/* maps socket fd to process */

#endif /* _TCP_LOW_H */
