/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: thindex.c,v 6.5 1999/12/31 23:16:43 jsquyres Exp $
 *
 *	Function:	- create hindexed derived datatype
 *	Accepts:	- # blocks
 *			- block length array
 *			- block displacement array (in bytes)
 *			- element datatype
 *			- new datatype (out)
 *	Returns:	- MPI_SUCCESS or error code
 */


#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
    MPI_Type_hindexed - Creates an indexed datatype with offsets in bytes

Input Parameters:
+ count - number of blocks -- also number of entries in indices and blocklens
. lengths - number of elements in each block (array of nonnegative integers) 
. disps - byte displacement of each block (array of MPI_Aint) 
- oldtype - old datatype (handle) 

Output Parameter:
. newtype - new datatype (handle) 

.N Wrapper MPI_Type_created_hindexed

.N ACK
@*/
int MPI_Type_hindexed(int count, int *lengths, 
		      MPI_Aint *disps, MPI_Datatype oldtype, 
		      MPI_Datatype *newtype)
{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPITHINDEX);

	err = MPI_Type_create_hindexed(count,
				lengths, disps, oldtype, newtype);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITHINDEX, err));
	}

	(*newtype)->dt_format = LAM_DTHINDEXED;

	lam_resetfunc_m(BLKMPITHINDEX);
	return(MPI_SUCCESS);
}
