/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: tcommit.c,v 6.3 1999/12/31 21:27:38 jsquyres Exp $
 *
 *	Function:	- commit a datatype
 *	Accepts:	- ptr to datatype
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * external functions
 */
extern int		lam_tr_dtype();

/*@
    MPI_Type_commit - Commits the datatype

Input Parameter:
. dtype - datatype (handle) 

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG
.N MPI_ERR_TYPE

.N ACK
@*/
int MPI_Type_commit(MPI_Datatype *dtype)
{
	lam_initerr();
	lam_setfunc(BLKMPITCOMMIT);

	if (dtype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCOMMIT, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else if (*dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCOMMIT, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else {
		if (lam_tr_dtype(*dtype)) {
			return(lam_errfunc(MPI_COMM_WORLD, BLKMPITCOMMIT,
					lam_mkerr(MPI_ERR_INTERN, errno)));
		}

		(*dtype)->dt_commit = 1;
	}

	lam_resetfunc(BLKMPITCOMMIT);
	return(MPI_SUCCESS);
}
