/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: start.c,v 6.3 1999/12/31 21:27:38 jsquyres Exp $
 *
 *	Function:	- start communication request
 *	Accepts:	- ptr to request
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern int		lam_errfunc();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();


/*@
    MPI_Start - Initiates a communication with a persistent request handle

Input Parameter:
. req - communication request (handle) 

Notes:

This function starts a communication that was previously initialized
with any of the 'MPI_*_init' functions.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG
.N MPI_ERR_REQUEST

.seealso MPI_Bsend_init, MPI_Request_free, MPI_Rsend_init, MPI_Send_init, MPI_Ssend_init, MPI_Startall, MPI_Test, MPI_Testall, MPI_Testany, MPI_Testsome, MPI_Wait, MPI_Waitall, MPI_Waitany, MPI_Waitsome

.N ACK
@*/
int MPI_Start(MPI_Request *req)
{
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPISTART);

	if (req == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPISTART, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (*req == MPI_REQUEST_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPISTART, lam_mkerr(MPI_ERR_REQUEST, 0)));
	}

	err = MPI_Startall(1, req);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc((*req)->rq_comm, BLKMPISTART, err));
	}

	lam_resetfunc(BLKMPISTART);
	return(MPI_SUCCESS);
}
