/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: querythr.c,v 6.3 2001/01/26 17:04:19 jsquyres Exp $
 *
 *	Function:	- query level of thread support in MPI
 *	Accepts:	- ptr to provided level
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdio.h>

#include <mpi.h>
#include <mpisys.h>
#include <lamthreads.h>
#include <blktype.h>


/*@
   MPI_Query_thread - Check level of thread support in MPI

Output Parameter:
. pprovided - provided level of thread support

Description:

This function is mainly here for link-compatability.  It will
[currently] only ever return 'MPI_THREAD_SINGLE' in 'pprovided'.
Future versions of LAM/MPI will support multi-threaded user programs,
in which case 'MPI_Init_thread' must be used to initialize MPI.  Hence,
programmers can use this function now in order to program for future
flexibility.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.seealso MPI_Init_thread(3), MPI_Is_thread_main(3)

.N WEB
@*/
int
MPI_Query_thread(int *pprovided)
{
  lam_setfunc(BLKMPIQUERYTHREAD);

  if (pprovided == NULL) {
    return(lam_errfunc(MPI_COMM_WORLD, BLKMPIQUERYTHREAD,
		       lam_mkerr(MPI_ERR_ARG, EMPIINIT)));
  }
  
  *pprovided = lam_thread_level;
  
  lam_resetfunc(BLKMPIQUERYTHREAD);
  return(MPI_SUCCESS);
}

