/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: isthrmain.c,v 6.3 2001/01/26 17:04:18 jsquyres Exp $
 *
 *	Function:	- see if this is the main MPI thread
 *	Accepts:	- ptr to flag
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdio.h>

#include <mpi.h>
#include <mpisys.h>
#include <lamthreads.h>
#include <blktype.h>


/*@
   MPI_Is_thread_main - determine if the caller is the main thread

Output Parameter:
. pflag - true if calling thread is main thread, false otherwise

Description:

This function is mainly here for link-compatability.  Since only the
'MPI_THREAD_SINGLE' level of thread concurrency is supported in
LAM/MPI, this function has limited usefulness.  Future versions of
LAM/MPI will support multi-threaded user programs, in which case
'MPI_Init_thread' must be used to initialize MPI.  Hence, programmers
can use this function now in order to program for future flexibility.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.seealso MPI_Init_thread(3), MPI_Query_thread(3)

.N WEB
@*/
int
MPI_Is_thread_main(int *pflag)
{
  lam_setfunc(BLKMPIISTHREADMAIN);
/*
 * Ensure we got a valid requested and pprovided
 */
  if (pflag == NULL) {
    return(lam_errfunc(MPI_COMM_WORLD, BLKMPIISTHREADMAIN,
		       lam_mkerr(MPI_ERR_ARG, EMPIINIT)));
  }
/*
 * Are we the main thread?
 */
  if (lam_thread_self() == lam_main_thread)
    *pflag = 1;
  else
    *pflag = 0;
  
  lam_resetfunc(BLKMPIISTHREADMAIN);
  return(MPI_SUCCESS);
}

