/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: infofree.c,v 6.6 2001/02/03 20:24:48 jsquyres Exp $
 *
 *	Function:	- free an info object
 *	Accepts:	- info (modified)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <all_list.h>
#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


/*@
  MPI_Info_free - Free an 'MPI_Info' object.

Input/Output Parameters:
. info - info object to be freed (handle)

Notes:

Upon successful completion, 'info' will be set to 'MPI_INFO_NULL'.

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_ARG

.N WEB
@*/
int MPI_Info_free(MPI_Info *info)
{
	struct _infoent	*p;			/* key/value pair */
	
	lam_initerr_m();
	lam_setfunc_m(BLKMPIINFOFREE);

	if (info == 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPIINFOFREE,
					lam_mkerr(MPI_ERR_ARG, 0)));
	}

	for (p = al_top((*info)->info_list); p;
			p = al_next((*info)->info_list, p)) {

		if (p->ie_value) {
			free(p->ie_value);
		}
	}
/*
 * Remove the fortran handle if the user called MPI_Info_f2c on this
 * handle
 */
	if ((*info)->info_f77handle >= 0)
	  lam_F_free_hdl((*info)->info_f77handle);

	(void) al_free((*info)->info_list);
	free((char *) *info);
	*info = MPI_INFO_NULL;

	lam_resetfunc_m(BLKMPIINFOFREE);
	return(MPI_SUCCESS);
}
