/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	NJN/RBD
 *
 *	$Id: waitsome_f.c,v 6.4 1999/09/02 01:34:39 prijks Exp $
 *
 *	Function:	- MPI_Waitsome F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_waitsome_(c, rqs, oc, idx, sts, ierr)

int			*c, *rqs, *oc, *idx, *sts, *ierr;

{
	MPI_Request	*reqs;
	MPI_Status	*stats;
	int		i;

	if (*c > 0) {
		reqs = (MPI_Request *) malloc((*c) * sizeof(MPI_Request));
		if (reqs == 0) {
			lam_setfunc(BLKMPIWAITSOME);
			*ierr = lam_err_comm(MPI_COMM_WORLD,
					MPI_ERR_OTHER, errno, "");
			return;
		}
	} else {
		reqs = 0;
	}

	for (i = 0; i <	*c; ++i) {
		reqs[i] = GETHDL(rqs[i]);
	}

	if ((void *) sts == lam_F_statuses_ignore) {
		stats = MPI_STATUSES_IGNORE;
	}
	else if ((void *) sts == lam_F_status_ignore) {
		lam_setfunc(BLKMPIWAITSOME);
		*ierr = lam_err_comm(MPI_COMM_WORLD, MPI_ERR_ARG, 0,
					"MPI_STATUS_IGNORE");
		return;
	}
	else {
		stats = (MPI_Status *) sts;
	}

	*ierr =	MPI_Waitsome(*c, reqs, oc, idx,	stats);

	if (*ierr == MPI_SUCCESS) {
		for (i = 0; i <	*c; ++i) {
			if (reqs[i] == MPI_REQUEST_NULL) {
				lam_F_free_hdl(rqs[i]);
				rqs[i] = -1;
			}

			if (i < *oc) {
				idx[i] += 1;
			}
		}
	}

	free((char *) reqs);
}
