/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: connect_f.c,v 6.4 1999/09/02 01:34:09 prijks Exp $
 *
 *	Function:	- MPI_Comm_connect F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_comm_connect_(port, info, root, comm, icomm, ierr, n)

char			*port;
int			*info, *root, *comm, *icomm, *ierr;
int			n;

{
	MPI_Comm	intercomm;
	char		*port_name;

	port_name = lam_F2C_string(port, n);
	if (port_name == 0) {
		lam_setfunc_m(BLKMPICOMMCONNECT);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPICOMMCONNECT,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr = MPI_Comm_connect(port_name, GETHDL(*info),
				*root, GETHDL(*comm), &intercomm);
	
	if (lam_F_make_hdl(icomm, ierr, intercomm, BLKMPICOMMCONNECT)) {
		intercomm->c_f77handle = *icomm;
	}

	free(port_name);
}
