/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: errset.c,v 6.4 1999/12/31 21:27:22 jsquyres Exp $
 *
 *	Function:	- set error handler for communicator
 *	Accepts:	- communicator
 *			- error handler
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
  MPI_Errhandler_set - Sets the error handler for a communicator

Input Parameters:
+ comm - communicator to set the error handler for (handle) 
- errhandler - new MPI error handler for communicator (handle) 

.N Wrapper MPI_Comm_set_errhandler

.N ACK
@*/
int MPI_Errhandler_set(MPI_Comm comm, MPI_Errhandler errhdl)
{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIERRSET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_err_comm(MPI_COMM_WORLD, MPI_ERR_COMM, 0,
			"null handle"));
	}

	if (errhdl == MPI_ERRHANDLER_NULL || !(errhdl->eh_flags & LAM_EHCOMM)) {
		return(lam_err_comm(comm, MPI_ERR_ARG, 0,
			"invalid error handler"));
	}
/*
 * Free previous error handler.
 */
	err = MPI_Errhandler_free(&(comm->c_errhdl));
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIERRSET, err));
	}
/*
 * Set the communicator's new error handler.
 */
	comm->c_errhdl = errhdl;
	errhdl->eh_refcount++;

	lam_resetfunc_m(BLKMPIERRSET);
	return(MPI_SUCCESS);
}
