/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: cgeterr.c,v 1.1 2001/02/03 20:55:03 bbarrett Exp $
 *
 *	Function:	- get error handler of communicator
 *	Accepts:	- communicator
 *			- error handler (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*@
    MPI_Comm_get_errhandler - Get error handler of communicator

Input Parameter:
+ comm - Communicator

Output Parameter:
+ errhdl - Error Handler

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_COMM
.N MPI_ERR_ARG

.seealso MPI_Comm_create_errhandler(3), MPI_Comm_set_errhandler(3)

.N WEB
@*/

int
MPI_Comm_get_errhandler(MPI_Comm comm, MPI_Errhandler *errhdl)
{
	lam_initerr();
	lam_setfunc(BLKMPICOMMGETERRHDL);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_err_comm(MPI_COMM_WORLD, MPI_ERR_COMM, 0,
			"null handle"));
	}

	if (errhdl == 0) {
		return(lam_err_comm(comm, MPI_ERR_ARG, 0, "null pointer"));
	}
/*
 * Get the communicator's error handler.
 */
	*errhdl = comm->c_errhdl;

	lam_resetfunc(BLKMPICOMMGETERRHDL);
	return(MPI_SUCCESS);
}
