/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Id: kdoom.c,v 6.4 1999/09/10 05:20:24 jsquyres Exp $
 *	
 *	Function:	- delivers a signal to a process
 *	Accepts:	- process identifier (0 means self)
 *			- signal number
 *	Returns:	- 0 or ERROR
 */

#include <kio.h>
#include <kreq.h>
#include <terror.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* kernel I/O block */

/*
 * external functions
 */
extern int		_cipc_kreq();		/* make kernel request */
extern void		_ksig_follow();		/* check signals */

int
kdoom(pid, signal)

int			pid;
int			signal;

{
	struct kreq	req;			/* kernel request */
	struct kreply	reply;			/* kernel reply */

	if (signal < 1) {
		if (kill(pid, -signal)) {
			return(ERROR);
		}
	} else {
/*
 * Check the signal number bounds.
 */
		if (signal > TNSIG) {
			errno = EINVAL;
			return(ERROR);
		}
/*
 * Formulate the KQDOOM kernel request.
 */
		LAM_ZERO_ME(req);
		LAM_ZERO_ME(reply);
		req.kq_req = KQDOOM;
		req.kq_index = _kio.ki_index;
		req.kq_pid = pid;
		req.kq_signal = sigmask(signal);

		if (_cipc_kreq(&req, &reply)) {
			return(ERROR);
		}
/*
 * Check signals.
 */
		if (reply.kr_signal) {
			_kio.ki_signal |= reply.kr_signal;
			_ksig_follow();
		}

		if (reply.kr_reply) {
			errno = reply.kr_reply;
			return(ERROR);
		}
	}

	return(0);
}
