/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: rpi_lamd.h,v 6.1 2001/01/10 19:59:08 jsquyres Exp $
 *
 *	Function:	- RPI implementation for LAM daemon
 *			- constants and templates
 */

#ifndef _RPI_LAMD_H
#define _RPI_LAMD_H

#include <net.h>

/*
 * lamd request
 */
struct lamd_req {
	struct nmsg	lmq_msg_data;		/* data LAM message */
	struct nmsg	lmq_msg_ack;		/* ack LAM message */
	struct nmsg	lmq_msg_ger;		/* GER LAM message */
	int		lmq_state;		/* progress state */
	int		lmq_flags;		/* misc. flags */
	int		lmq_ndata;		/* #bytes to ship */
	int		lmq_ndata_moved;	/* #bytes shipped */
};

/*
 * lamd request states
 */
#define LAMD_START	0			/* no communication yet */
#define LAMD_ACK	1			/* ship ack next */
#define LAMD_TAIL	2			/* shipping data tail */
#define LAMD_GER	4			/* GER protocol */
#define LAMD_DONE	3			/* completed */

/*
 * lamd request flags
 */
#define LAMD_RECVMODE	1			/* recv or probe */
#define LAMD_SSEND	2			/* msg is synchronous */

/*
 * polling defaults
 */
#ifndef MPIL_LPD_BASE
#define MPIL_LPD_BASE	50000
#endif

#ifndef MPIL_LPD_MAX
#define MPIL_LPD_MAX	1000000
#endif

/*
 * public functions
 */
int			_rpi_lamd_init(void);
int			_rpi_lamd_addprocs(void);
int			_rpi_lamd_build(MPI_Request req);
int			_rpi_lamd_start(MPI_Request req_top,
					MPI_Request req);
int			_rpi_lamd_destroy(MPI_Request req);
int			_rpi_lamd_advance(MPI_Request req_top,
					  int flag_block);
int			_rpi_lamd_iprobe(MPI_Request req);
int			_rpi_lamd_finalize(struct _proc	*p);


#endif	/* _RPI_LAMD_H */
