/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: lamnet.h,v 6.6 2000/07/14 23:29:27 jsquyres Exp $
 * 
 *	Function:	- LAM network description
 */

#ifndef _LAMNET
#define _LAMNET

#include <lam_config.h>
#include <sys/types.h>
#include <netinet/in.h>

#include <portable.h>

/*
 * default filenames
 */
#define DEFFBHOST	"lam-bhost.def"	/* default host file */

/*
 * default search paths
 */
#ifndef DEFPBHOST
#define DEFPBHOST	"/tmp/lam/boot"	/* default boot directory */
#endif

/*
 * default tools
 */
#define DEFTHBOOT	"hboot"
#define DEFTTKILL	"tkill"
#define DEFTWIPE	"wipe"

/*
 * node description
 */
struct lamnode {			/* node information */
	int4		lnd_nodeid;	/* node identifier */
	int4		lnd_type;	/* node type */
	int4		lnd_ncpus;	/* number of CPUs on node */
	int		lnd_bootport;	/* booting port # */
	char		*lnd_hname;	/* host name */
	char		*lnd_uname;	/* user name */
	struct sockaddr_in
			lnd_addr;	/* internet address */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		lamnet_dups __ARGS((struct lamnode *lamnet,
					int nlamnet, int *pdup));
extern int		lamnet_findhosts __ARGS((struct lamnode *lamnet,
					int nlamnet, int *badhost));
extern int		lamnet_findorig __ARGS((struct lamnode *lamnet,
					int nlamnet));

#ifdef __cplusplus
}
#endif

#endif	/* _LAMNET */
