/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: flatreq.h,v 6.6 1999/06/16 05:54:51 jsquyres Exp $
 *
 *	Function:	- constants and structures associated
 *			  with the flat server
 */

#ifndef _FLATREQ_H
#define _FLATREQ_H

#include "lam_config.h"
#include "net.h"
#include "portable.h"
#include "preq.h"

/*
 * constants
 */
#define FLPATHLEN	96			/* load file path length */
#define FLMAX		256
#define	EMPTY		((char *) 0)

/*
 * request codes
 */
#define FLQLOAD		1
#define FLQGET		2
#define FLQFORGET	3
#define FLQDONE		4
#define FLQCLEAN	5

/*
 * request template
 */
struct flreq {
	int4		flq_src_node;
	int4		flq_src_event;
	int4		flq_req;
	int4		flq_parm1;
#define flq_tag		flq_parm1
#define flq_pid		flq_parm1
	int4		flq_parm2;
#define flq_malength	flq_parm2
#define flq_dseg	flq_parm2
	int4		flq_parm3;
#define flq_ldlength	flq_parm3
};

/*
 * reply template
 */
struct flreply {
	int4		flr_reply;
};

/*
 * flat table entry
 */
struct flregion {
	int4		fl_tag;			/* identifying tag */
	int4		fl_status;		/* status flag */
	int4		fl_src_event;		/* sender's -pid */
	int4		fl_src_node;		/* sender's nodeid */
	int4		fl_byteswritten;	/* how many so far */
	char		*fl_addr;		/* flatted file name */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		rflat __ARGS((int4, char *, int4, int4, int4));
extern int		rflatv __ARGS((int4, char **, struct penv *,
    					int4 *, int4 *));
extern int		rflclean __ARGS((int4, int4));
extern char		*rget __ARGS((int4, int4));

#ifdef __cplusplus
}
#endif

#endif /* _FLATREQ_H */
