/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	RBD
 *
 *	$Log: memucmp.c,v $
 *	Revision 6.2  1999/05/24 16:56:49  kmeyer1
 *	added $copyright$
 *	
 *	Revision 6.1  1996/11/23 19:58:02  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:47:22  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:57:04  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:56:52  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:35:01  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/07/22  13:58:47  raja
 * pre-release to 2.3
 * 
 *	Function:	- compare arrays of bytes (unsigned characters)
 *	Accepts:	- ptr to first array
 *			- ptr to second array
 *			- # of bytes
 *	Returns:	- -1, 0, +1 (m1 < m2, m1 == m2, m1 > m2)
 */

#include <portable.h>

int
memucmp(m1, m2, nbytes)

unsigned char		*m1;
unsigned char		*m2;
int4			nbytes;

{
	for (; nbytes > 0; --nbytes, ++m1, ++m2) {

		if (*m1 < *m2) {
			return(-1);
		}
		else if (*m1 > * m2) {
			return(1);
		}
	}

	return(0);
}
