/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *
 *      Software for Humanity
 *      This program is freely distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	$Id: kenyad.int.c,v 6.2 1999/06/12 17:11:36 kmeyer1 Exp $
 * 
 *	Function:	- internal OTB process management server
 */

#include <fcntl.h>
#include <unistd.h>

#include <terror.h>

/*
 * external variables
 */
extern int	diedfd;
extern int	diesigfd;

/*
 *	chldpipe_init
 *
 *	Function:	- sigchld handling initialization
 */
void
chldpipe_init(void)
{
    int		fds[2];
/*
 * Set up pipe for handling SIGCHLDs. Make it close-on-exec.
 */
    if (pipe(fds))
	lampanic("kenyad (pipe)");

    if (fcntl(fds[0], F_SETFD, 1) == -1)
	lampanic("kenyad (fcntl)");

    if (fcntl(fds[1], F_SETFD, 1) == -1)
	lampanic("kenyad (fcntl)");

    diedfd = fds[0];
    diesigfd = fds[1];
}
