/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN
 *
 *	$Id: iod.int.c,v 6.5 2000/02/08 10:29:22 jsquyres Exp $
 *
 *	Function:	- internal IO daemon
 */

#include <typical.h>

/*
 * public functions
 */
void			(*(iod()))();
void			io_accept();
void			io_register();
void			io_deregister();

/*
 * external functions
 */
extern void		kio_intr();
extern void		kio_intr_clr();
extern void		io_forward();
extern void		io_new();

/*
 *	iod
 *
 *	Function:	- server loop
 */
void (*(
iod()))()

{
	return((void (*)()) iod);
}

/*
 *	io_accept
 *
 *	Function:	- prepare to accept client connections
 *	Accepts:	- IO server file descriptor
 */
void
io_accept(fd)

int			fd;

{
	kio_intr(fd, io_new, FALSE);
}

/*
 *	io_register
 *
 *	Function:	- register a new client connection
 *			- iod will now read and forward client data
 *	Accepts:	- client file descriptor
 */
void
io_register(fd)

int			fd;

{
	kio_intr(fd, io_forward, FALSE);
}

/*
 *	io_deregister
 *
 *	Function:	- deregister a client connection
 *			- iod will no longer read and forward client data
 *	Accepts:	- client file descriptor
 */
void
io_deregister(fd)

int			fd;

{
	kio_intr_clr(fd);
}
