/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: fqstate.c,v 6.2 1999/06/12 17:11:30 kmeyer1 Exp $
 * 
 *	Function:	- FQSTATE request
 *			- a monitoring request with no associated file
 *			  operation
 */

#include <string.h>

#include "filed.h"
#include <freq.h>
#include <net.h>
#include <t_types.h>
#include <terror.h>

/*
 * external variables
 */
extern char		fbuf[];		/* general purpose message buffer */
extern struct fdesc	*fdtop;		/* top of descriptor list */

/*
 * external functions
 */
void			fsendr();	/* general purpose file reply */

/*
 *	fqstate
 *
 *	Function:	- sends back every file descriptor
 *	Accepts:	- filed request
 *			- assumes MAXNMSGLEN > sizeof(struct fdesc)
 */
void
fqstate(fq)

struct freq		*fq;

{
	struct fdesc	*f;		/* ptr to target descriptor */
	struct fstate	*p;		/* ptr to desc state */
	int4		n;		/* total space used in buf */

	p = (struct fstate *) fbuf;
	n = 0;

	for (f = fdtop; f != FDNULL; f = f->f_next) {
/*
 * If buffer is almost full, send it back to the client and reset.
 */
		if ((n + sizeof(struct fstate)) > MAXNMSGLEN) {
			fsendr(fq->fq_src_node, fq->fq_src_event,
					0, INT4_NIL, n, INT4_NIL);
			p = (struct fstate *) fbuf;
			n = 0;
		}
/*
 * Add to the buffer.
 */
		else {
			p->fs_tfd = ltot(f->f_tfd);
			p->fs_tflags = ltot(f->f_tflags);
			p->fs_flow = ltot(f->f_flow);
			p->fs_count = ltot(f->f_count);
			p->fs_src_node = ltot(f->f_src_node);
			p->fs_src_event = ltot(f->f_src_event);
			strcpy(p->fs_name, f->f_name);
			p += 1;
			n += sizeof(struct fstate);
		}
	}

	fsendr(fq->fq_src_node, fq->fq_src_event, EEOF, INT4_NIL, n, 0);
}
