/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres and Arun Rodrigues with Brian Barrett,
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 * 
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *      $Id: kdump.c,v 6.4 2001/01/22 22:31:52 jsquyres Exp $
 * 
 *	Function:	- prompts kernel to dump process state
 */

#include <errno.h>

#include <kreq.h>
#include <terror.h>


/*
 * external functions
 */
extern int		_cio_kreq();
extern int		_cipc_init();


int
main(int argc, char* argv[])
{
	struct kreq	req;		/* kernel request */
	struct kreply	reply;		/* kernel reply */

	if (_cipc_init()) {
		terror("kdump");
		return(errno);
	}

	req.kq_req = KQDUMP;
	req.kq_index = -1;

	if (_cio_kreq(&req, &reply)) {
		terror("kdump");
		return(errno);
	}

	return(0);
}
