dnl -*- shell-script -*-

#
# $Id: lam_get_fortran_ext_name_convention.m4,v 1.1 2000/10/17 12:05:18 jsquyres Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_GET_FORTRAN_EXT_NAME_CONVENTION,[
# Determine underscore generation for external names.
# arg is FORTRAN compiler name
AC_MSG_CHECKING($1 external naming convention)
cat > conftestf.f <<EOF
       subroutine FOO_bar(a)
       integer a
       a = 1
       return
       end
EOF
$1 $FFLAGS -c conftestf.f 1>&5 2>&1
if test ! -s conftestf.o; then
    AC_MSG_WARN(unable to produce an object file testing FORTRAN compiler)
else
    nm conftestf.o | grep foo_bar__ > /dev/null 2>&1
    if test $? = "0"; then 
	AC_MSG_RESULT(FORTRANDOUBLEUNDERSCORE)
	AC_DEFINE(LAM_FORTRANDOUBLEUNDERSCORE)
	lam_ac_doubleunder=y
    else
	nm conftestf.o | grep foo_bar_ > /dev/null 2>&1
	if test $? = "0"; then 
	    AC_MSG_RESULT(FORTRANUNDERSCORE)
	    AC_DEFINE(LAM_FORTRANUNDERSCORE)
	    lam_ac_singleunder=y
	else
	    # We may get into trouble here if we start accepting mixed
	    # case compilers -- we may need to have caps underscore,
	    # or caps double underscore, for example.  But we haven't
	    # found any that require that yet.  :-)
	    nm conftestf.o | grep FOO_bar > /dev/null 2>&1
	    if test $? = "0"; then 
		AC_MSG_RESULT([mixed case, so FORTRANCAPS])
		AC_DEFINE(LAM_FORTRANCAPS)
		lam_ac_caps=y
	    else
		nm conftestf.o | grep foo_bar > /dev/null 2>&1
		if test $? = "0"; then 
		    AC_MSG_RESULT(FORTRANNOUNDERSCORE)
		    AC_DEFINE(LAM_FORTRANNOUNDERSCORE)
		    lam_ac_nounder=y
		else
		    nm conftestf.o | grep FOO_BAR > /dev/null 2>&1
		    if test $? = "0"; then 
			AC_MSG_RESULT(FORTRANCAPS)
			AC_DEFINE(LAM_FORTRANCAPS)
			lam_ac_caps=y
		    else
			AC_MSG_WARN(couldn't find name of subroutine foo_bar)
		    fi
		fi
	    fi
	fi
    fi
fi
/bin/rm -f conftestf.f conftestf.o])dnl
dnl #$%#% emacs shell-script mode: '
