dnl -*- shell-script -*-

#
# $Id: lam_get_alignment.m4,v 1.1 2000/10/17 12:05:18 jsquyres Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_GET_ALIGNMENT,[
# Determine datatype alignment. 
# First arg is type, 2nd (optional) arg is config var to define.
AC_MSG_CHECKING(alignment of $1)
cat > conftest.c <<EOF
#include <stddef.h>
#include <stdio.h>
#include <malloc.h>
#include <stdlib.h>
void exit(int);
struct foo { char c; $1 x; };
int main(int argc, char* argv[])
{
    struct foo *p = (struct foo *) malloc(sizeof(struct foo));
    int diff;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    diff = ((char *)&p->x) - ((char *)&p->c);
    fprintf(f, "%d\n", (diff >= 0) ? diff : -diff);
    return 0;
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_ac_align=`cat conftestval`
    AC_MSG_RESULT($lam_ac_align)
    if test -n "$2"; then
	AC_DEFINE_UNQUOTED($2,$lam_ac_align)
    fi
else
    AC_MSG_WARN(error compiling/running conftest)
fi
/bin/rm -f conftest*])dnl

