(* $Id: constants.ml,v 1.1.1.1 2002/02/25 07:49:29 garrigue Exp $ *)
open Str
open Unix

let doctype = Printf.sprintf "Caml IRC client %d.%d" 1 1
let software = "CamlIRC"
let version = "0.01"
let datestring = 
  match split (regexp " ") "$Date: 2002/02/25 07:49:29 $" with
  | [_;date;time;_] ->
      date^"-"^(global_replace (regexp ":") "-" time) 
  | _ -> "" 

(* *)

let id = software^" "^version^"("^datestring^")"
and author = ""

let config_file = (getpwnam (getlogin ())).pw_dir^"/.camlirc.xml"
