/***************************************************************************
                          kxmleditorpart.h  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORPART_H
#define KXMLEDITORPART_H

#include <kparts/part.h>
#include <kparts/browserextension.h>

#include <qdom.h>
#include <qptrlist.h>

#include "kxe_treeview.h"

#define FILE_DIALOG_FILTER "*.xml|XML files\n*.xsl|XSL files\n*.xslt|XSLT files\n*.svg|SVG files\n*.xul|XUL files\n*.rc|Resource UI files\n*.ui|User Interface UI files\n*|All files"

class QTabWidget;
class KXE_ViewElement;
class KXESearchDialog;
class QTextEdit;
class KAction;
class KToolBarPopupAction;
class KXmlEditorComboAction;
class QDomNode;
class QKeyEvent;
class KXMLEditorPartIfaceReadOnly; // DCOP interface
class KCommandHistory;
class KPrinter;
class QSplitter;
class KXEDocument;


/** @short This is the KPart of KXMLEditor. */
class KXMLEditorPart : public KParts::ReadWritePart
{
		Q_OBJECT

public:
		/** @short Constructor

		Creates the actions, the view (widgets) and changes to "begin state".
		*/
		KXMLEditorPart( bool fReadWrite, KXEDocument* pDocument, QWidget * pParent, const char * pszName );

		/** @short Destructor */
		virtual ~KXMLEditorPart();

		/** @short Changes the behaviour of this part to readonly or readwrite. */
		virtual void setReadWrite( bool fReadWrite = true );

		/** @short Returns the selected XML object's path or an empty string, if no object is selected. */
		QString getSelectedPath() const { return m_pViewTree->getSelectedPath(); }

		/** @short Copy XML node into clipboard */
		QTextDrag * copyNode(QDomNode *);

		/** @short Paste XML node from clipboard into document */
		bool pasteNode(QDomNode *, QMimeSource *);

		/** @short Drag&Drop move */
		bool dropMoveNode(QDomElement &, QDomNode &);

		/** @short Prints the document on specified printer.
			@param pPrinter printer which will be used for printing. */
		virtual void print(KPrinter* pPrinter);

		/** @short Returns underlying document. */
		KXEDocument* document()  	{ return m_pDocument; }

		/** @short Changes underlying document object */
		void setDocument(KXEDocument *pDocument);

public slots:
		/**
		 * Reimplemented from @ref KParts::KReadWritePart::setModified.
		 *
		 * Alters the window caption according to the given flag and
		 * calls the base functionality.
		 */
		virtual void setModified( bool fModified );

		/** @short Updates tree view after creating new element */
		void updateNodeCreated(const QDomNode & node);

		/** @short Updates tree view after deleting new element */
		void updateNodeDeleted(const QDomNode & node);

		/** @short Updates tree view after change element properties */
		void updateNodeChanged( const QDomElement & domElement );

		/** @short Updates tree view after change char. data properties */
		void updateNodeChanged( const QDomCharacterData & node ) ;

		/** @short Updates tree view after change proc. instr. properties */
		void updateNodeChanged( const QDomProcessingInstruction &domProcInstr );

		/** @short Updates tree view after move node */
		void updateNodeMoved( const QDomNode & node );

		/**
		 * @short Reimplemented from @ref KParts::KReadWritePart::setModified.
		 */
		virtual void setModified() { setModified(true);  }
		
		/** @short Slot connected to File->Save As action. */
		bool slotFileSaveAs();

		/** @short Inserts special proc.instruction into document. */
		void slotActVersionEncoding();

		/** @short Called on user's action response.
		Creates <?xml-stylesheet ...?> processing instruction
		with reference to specified stylesheet URI.
		*/
		void slotActAttachStylesheet();
	
		/** @short Called on user's action response. */
		void slotActDetachStylesheet();
	
		/** @short Called on user's action response */
		void slotActDetachSchema();
	
		/** @short Called on user's action response */
		void slotActAttachSchema();

		/** @short Cut the marked text/object into the clipboard */
		void slotEditCut();

		/** @short Copy the marked text/object into the clipboard */
		void slotEditCopy();

		/** @short Paste the clipboard into the document */
		void slotEditPaste();

		/** @short Displays search dialog and finds string in this tree view */
		void slotEditFind();

		/** @short Finds next occurence of string in this tree view */
		void slotEditFindNext();

		/** @short Deselects currently selected item */
		void slotEditDeselect() { m_pViewTree->editDeselect(); }

		/** @short Selects the selected item's parent item. */
		void slotViewNodeUp() { m_pViewTree->viewNodeUp(); }

		/** @short Expands the selected tree item's subtree. */
		void slotViewExpNode() { m_pViewTree->viewExpNode(-1); }

		/** @short Expands the selected tree item's subtree to the given level. */
		void slotViewExpNode( int nLevel ) { m_pViewTree->viewExpNode(nLevel); }

		/** @short Collapses the selected tree item's subtree. */
		void slotViewColNode() { m_pViewTree->viewColNode(0); }

		/** @short Collapses the selected tree item's subtree to the given level. */
		void slotViewColNode( int nLevel ) { m_pViewTree->viewColNode(nLevel); }

		/** @short Insert XML element into document */
		void slotXmlElementInsert();

		/** @short Edit XML element */
		void slotXmlElementEdit();

		/** @short Add attribute to an XML element. */
		void slotXmlAttributesAdd();

		/** @short Delete all attributes of an XML element. */
		void slotXmlAttributesDel();

		/** @short Delete an attribute of an XML element. */
		void slotXmlAttributeDel();

		/** @short Insert proc.instruction into document */
		void slotXmlProcInstrInsert();

		/** @short Edit proc.instruction */
		void slotXmlProcInstrEdit();

		/* @short Insert text into element. */
		void slotActInsertText();

		/* @short Insert CDATA section. */
		void slotActInsertCDATA();

		/* @short Insert comment to element. */
		void slotActInsertComment();

		/* @short Edit character data */
		void slotXmlCharDataEdit();

		/* @short Moves a node up (change its position with its prev. siblings position) */
		void slotXmlMoveNodeUp();

		/* @short Moves a node down (change its position with its next siblings position) */
		void slotXmlMoveNodeDown();

		/** @short toggles bookmark on the selected item */
		void slotBookmarksToggle();

		/** @short Searches for the previous bookmarked item */
		void slotBookmarksPrev() { m_pViewTree->bookmarksPrev(); }

		/** @short Searches for the next bookmarked item */
		void slotBookmarksNext() { m_pViewTree->bookmarksNext(); }

		/** @short Shows configuration dialog (@ref OptionsDialog) */
		void slotConfigure();

		void slotPathSelected( const QString & szPath );
		void slotPathSelected();
		void slotPathClear();

		/** @short Called when a tree view items text was changed via inplace-renaming. */
		void slotItemRenamedInplace( QListViewItem * pItem );

		/** @short Called whan an attributes name was changed via inplace editing. */
		void slotAttributeNameChangedInplace( const QDomAttr &, const QString );

		/** @short Called whan an attributes value was changed via inplace editing. */
		void slotAttributeValueChangedInplace( const QDomAttr &, const QString );

		/** @short Called when File->Print or icon from the toolbar is selected. */
		void slotActPrint();

		/** @short Slot for editing node properties. */
		void slotActProperties();

		/** @short Slot for editing xml as a text in separate dialog window. */
		void slotActEditRawXml();

		/** @short Slot for removing XML nodes. */
		void slotActDelete();

		void slotTreeViewKeyPressed(QKeyEvent *e);

		/** @short Slot that performs redo function. */
		void slotActRedo();

		/** @short Slot that performs undo function. */
		void slotActUndo();

protected:

		void updateActions();
		
		/** @short Opens the file @ref KParts::ReadOnlyPart::m_file. */
		virtual bool openFile();

		/** @short Saves the file @ref KParts::ReadOnlyPart::m_file. */
		virtual bool saveFile();

		/** @short Draws header for printouts (made of file name).
			@param painter a painter to use for drawing
			@param pageNumber number of currently drawn page counted from 0
			@param ypos y coordinate of upper border of the header
			@sa printPage() @sa printFooter()
		*/
		void printHeader(QPainter* painter, int pageNumber, int ypos, int width);

		/** @short Draws footer for printouts (page number).
			@param painter a painter to use for drawing
			@param pageNumber number of currently drawn page counted from 0
			@param ypos y coordinate of upper border of the footer
			@sa printHeader() @sa printFooter()
		*/
		void printFooter(QPainter* painter,int pageNumber, int ypos, int width);

		/** @short Draws page for printing purposes.

		If there are more pages to print, method
		returns true. Otherwise returns false.
			@param painter a painter to use for srawing
			@param pageNumber number of currently drawn page counted from 0
			@param top y coordinate of upper edge from where page should be drawn
			@param width,height size of the medium (e.g. paper)
			@sa printPage() @sa printHeader()
		*/
		bool printPage(QPainter* painter,int pageNumber, int top, int width, int height);

		/** @short Used in printing function printPage(). */
		unsigned int m_printLineNumber;

		/** @short Used in printing function printPage(). */
		QStringList m_printLines;

		// the actions
		KAction * m_pActEditFind;
		KAction * m_pActEditFindNext;
		KAction * m_pActEditDeselect;
		KAction * m_pActViewNodeUp;
		KToolBarPopupAction * m_pActViewExpNode;
		KToolBarPopupAction * m_pActViewColNode;
		KAction * m_pActXmlElementInsert;
		KAction * m_pActXmlAttributesAdd;
		KAction * m_pActXmlAttributesDel;
		KAction * m_pActXmlAttributeDel;
		KAction * m_pActXmlProcInstrInsert;
		KAction * m_pActInsertText;
		KAction * m_pActInsertCDATA;
		KAction * m_pActInsertComment;
		KAction * m_pActXmlMoveNodeUp;
		KAction * m_pActXmlMoveNodeDown;
		KAction * m_pActBookmarksToggle;
		KAction * m_pActBookmarksPrev;
		KAction * m_pActBookmarksNext;
		KXmlEditorComboAction * m_pActPathCombo;

	protected slots:
		void started();
		void completed();
		void canceled();

		/** @short Enables/disables actions and changes views  */
		void slotSelectionCleared(bool);

		/** @short Enables/disables actions depending on the given XML element and changes views  */
		void slotSelectionChanged( const QDomElement & );

		/** @short Enables/disables actions and changes views */
		void slotSelectionChanged( const QDomCharacterData & );

		/** @short Enables/disables actions and changes views */
		void slotSelectionChanged( const QDomProcessingInstruction & );

		/** @short Shows the requested context menu at the given position. */
		void slotContextMenuRequested( const QString & szMenuName, const QPoint & pos );

		/** @short Invoked everytime document has new content */
		void slotDocOpened();

	private:
		/** this view displays the XML-document's tree structure */
		KXE_TreeView * m_pViewTree;

		/** the tab widget, contains: m_pViewElement, m_pViewContents */
		QTabWidget * m_pTabWidget;

		/** widget to display XML element */
		KXE_ViewElement * m_pViewElement;

		/** edit widget for contents */
		QTextEdit * m_pViewContents;

		/** widget to display a proc.instr. */
		QTextEdit * m_pViewProcInstr;

		/** the search dialog, used for find action */
		KXESearchDialog * m_pDlgSearch;

		/** DCOP object having access to XML document. It may by NULL if no DCOP inteface is provided
		or read only privided by @ref KXMLEditorPartReadOnlyIface or full read-write @ref KXMLEditorPartIface .*/
		KXMLEditorPartIfaceReadOnly * m_pDCOPIface;

		bool m_bAlreadyModified;

		/** our browser extension */
		KParts::BrowserExtension * m_pBrowserExt;
		
		/** @short Stores pointer to command history list, which provide undo/redo functionality */
		KCommandHistory* m_pCmdHistory;
		
		/** @short Action for cutting nodes to clipboard.*/
		KAction* m_pActEditCut;

		/** @short Action for copying nodes to clipboard.*/
		KAction* m_pActEditCopy;

		/** @short Action for pasting nodes from clipboard.*/
		KAction* m_pActEditPaste;

		/** Action for editing properties of currently selected node. */
		KAction* m_pActProperties;

		/** Action for editing raw XML of currently selected node. */
		KAction* m_pActEditRawXml;

		/** Action for deleting currently selected node. */
		KAction* m_pActDelete;

		/** @short Action for changing version and encoding of XM file. */
		KAction* m_pActVersionEncoding;

		/** @short Action for attaching stylehseets to xml files. */
		KAction* m_pActAttachStylesheet;

		/** @short Action for detaching stylehseets from xml files. */
		KAction* m_pActDetachStylesheet;

		/** @short Action for attaching schemas to xml files. */
		KAction* m_pActAttachSchema;

		/** @short Action for detaching schemas from xml files. */
		KAction* m_pActDetachSchema;
		
		/** Printer object. */
		KPrinter *m_pPrinter;

		/** spitter - main widget in the part */
		QSplitter *pSplitter;

		/** Pointer to underlying KXEDocument object */
		KXEDocument* m_pDocument;
		
signals:
		// Add URL to recent file list
		void sigAddRecentURL(const KURL &);
};

/**
 * The browser extension for our part (@ref KXMLEditorPart).
 */
class KXMLEditorBrowserExtension : public KParts::BrowserExtension
{
		Q_OBJECT

	public:
		/** @short Constructor */
		KXMLEditorBrowserExtension( KXMLEditorPart * pParent, const char * pszName = "KXMLEditorBrowserExtension" )
			: KParts::BrowserExtension( pParent, pszName ),
			m_pPart(pParent)
			{ emit enableAction("print", true); }

	public slots:
		void slotEditCut() { m_pPart->slotEditCut(); }
		void slotEditCopy() { m_pPart->slotEditCopy(); }
		void slotEditPaste() { m_pPart->slotEditPaste(); }
		void print() { m_pPart->slotActPrint(); }

	protected:
		/** @short Stores pointer to the part. */
		KXMLEditorPart * m_pPart;
};

#endif

