/***************************************************************************
                          commands_edit  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : a_charytoniuk@user.sourceforge.net
 ***************************************************************************/

 /***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMANDS_EDIT_H
#define COMMANDS_EDIT_H

#include "kxecommand.h"

#include <klocale.h>

#include <qobjectlist.h>

/**
@file
@author The KXMLEditor Team
*/

/**
	@brief Command for removing any kind of nodes.
*/
class KXEDeleteNodeCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDeleteNodeCommand(KXEDocument*, QDomNode &);
		/** @brief Destructor */
		~KXEDeleteNodeCommand();
		/** @brief Performs node removal.*/
		virtual void execute();
		/** @brief Node removal rollback.*/
		virtual void unexecute();
		virtual QString name() const { return i18n("Delete node"); }
	protected:
		/** @short Stores infromation about parent node of the node to be deleted. */
		QDomNode m_domParentNode;
		/** @short Stores infromation the node to be deleted. */
		QDomNode m_domNode;
		/** @short Stores infromation about sibling node of the node to be deleted. */
		QDomNode m_afterNode;
};
/**
	@short Command for removing element attributes.
*/
class KXEDeleteAttrCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDeleteAttrCommand(KXEDocument*, QDomElement &, QDomAttr &);
		/** @brief Destructor */
		~KXEDeleteAttrCommand();
                /** @brief Preforms attributte removal. */
		virtual void execute();
                /** @brief Attributte removal rollback. */
		virtual void unexecute();
		virtual QString name() const { return i18n("Delete attribute"); }
	protected:
		/** @brief Stores attribute owner. */
		QDomElement m_domOwnerElement;
		/** @brief Attribute about to be removed. */
		QDomAttr m_domAttr;
};

/**
	@short Command for removing all element attributes.
*/
class KXEDeleteAllAttribCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDeleteAllAttribCommand(KXEDocument*, QDomElement &);
		/** @brief Destructor */
		~KXEDeleteAllAttribCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Delete all attributes"); }
	protected:
		QDomElement m_domOwnerElement;
		QPtrList<QDomAttr> m_listRemovedAttributes;
};

/**
	@short Command for cutting element to clipboard.
*/
class KXECutCommand : public KXEDeleteNodeCommand
{
	public:
		/** @brief Constructor */
		KXECutCommand(KXEDocument*, QDomNode &);
		/** @brief Destructor */
		~KXECutCommand();
		virtual QString name() const { return i18n("Cut node"); }
};

/**
	@short Command for pasting to document from clipboard.
*/
class KXEPasteToDocumentCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToDocumentCommand(KXEDocument*, QDomDocument *, QDomElement &);
		/** @brief Destructor */
		~KXEPasteToDocumentCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to document"); }
	protected:
		QDomDocument * m_pDomTargetDoc;
		QDomElement m_domSourceElement;
};

/**
	@short Command for pasting element from clipboard.
*/
class KXEPasteToElementCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToElementCommand(KXEDocument*, QDomElement &, QDomNode &);
		/** @brief Destructor */
		~KXEPasteToElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to element"); }
	protected:
		QDomElement m_domTargetElement;
		QDomNode m_domSourceNode;
};

class KXEPasteToProcInstrCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToProcInstrCommand(KXEDocument*, QDomProcessingInstruction &, QDomProcessingInstruction &);
		/** @brief Destructor */
		~KXEPasteToProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to proc. instruction"); }
	protected:
		QDomProcessingInstruction m_domTargetProcInstr;
		QString m_strNewData;
		QString m_strOldData;
};

class KXEPasteToCharDataCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEPasteToCharDataCommand(KXEDocument*, QDomCharacterData &, QDomCharacterData &);
		/** @brief Destructor */
		~KXEPasteToCharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Paste node to char. data"); }
	protected:
		QDomCharacterData m_domTargetCharData;
		QString m_strNewData;
		QString m_strOldData;
};

/**
	@short Command for Drag & Drop.
*/
class KXEDragDropMoveCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDragDropMoveCommand(KXEDocument*, QDomElement &, QDomNode &);
		/** @brief Destructor */
		~KXEDragDropMoveCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Drag&&drop node"); }
	protected:
		QDomElement m_domTargetElement;
		QDomNode m_domSourceNode;
		QDomNode m_domPreviousParentNode;
};

/**
	@short Command for moving selected node up.
*/
class KXEUpCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEUpCommand(KXEDocument*, QDomNode &);
		/** @brief Destructor */
		~KXEUpCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Move node up"); }
	protected:
		QDomNode m_domParentNode;
		QDomNode m_domNode;
};

/**
	@short Command for moving selected node down.
*/
class KXEDownCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEDownCommand(KXEDocument*, QDomNode &);
		/** @brief Destructor */
		~KXEDownCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Move node down"); }
	protected:
		QDomNode m_domParentNode;
		QDomNode m_domNode;
};

class KXEEditCharDataCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditCharDataCommand(KXEDocument*, QDomCharacterData &, const QString);
		/** @brief Destructor */
		~KXEEditCharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing character data"); }
	protected:
		QDomCharacterData m_domCharacterData;
		QString m_strNewContents;
		QString m_strOldContents;
};

/**
	@short Command for editing selected processing instruction.
*/
class KXEEditProcInstrCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditProcInstrCommand(KXEDocument*, QDomProcessingInstruction &, const QString);
		/** @brief Destructor */
		~KXEEditProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing proc. instruction"); }
	protected:
		QDomProcessingInstruction m_domProcInstr;
		QString m_strNewData;
		QString m_strOldData;
};

/**
	@short Command for editing selected XML element.
*/
class KXEEditElementCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditElementCommand(KXEDocument*, QDomElement &, const QString, const QString);
		/** @brief Destructor */
		~KXEEditElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing element"); }
	protected:
		QDomElement m_domElement;
		QString m_strNewPrefix;
		QString m_strNewName;
		QString m_strOldPrefix;
		QString m_strOldName;
};

/**
	@short Command for editing element attribute value.
*/
class KXEEditAttrValueCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditAttrValueCommand(KXEDocument*, const QDomAttr &, const QString);
		/** @brief Destructor */
		~KXEEditAttrValueCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Edit attribute value"); }
	protected:
		QDomAttr m_domAttr;
		QString m_strNewValue;
		QString m_strOldValue;
};

/**
	@short Command for editing element attribute names.
*/
class KXEEditAttrNameCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditAttrNameCommand(KXEDocument*, const QDomAttr &, const QString);
		/** @brief Destructor */
		~KXEEditAttrNameCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Edit attribute name"); }
	protected:
		QDomElement m_domOwnerElement;
		QString m_strNewName;
		QString m_strOldName;
		QString m_strValue;
		QString m_strNamespaceURI;
};

/**
	@short Command for editing XML element as text.
*/
class KXEEditRawXmlCommand : public KXECommand
{
	public:
		/** @brief Constructor */
		KXEEditRawXmlCommand(KXEDocument*, QDomElement &, QDomElement &);
		/** @brief Destructor */
		~KXEEditRawXmlCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Editing raw XML"); }
	protected:
		QDomElement m_domOldElement;
		QDomNode m_domParentNode;
		QDomElement m_domNewElement;
		QDomNode m_afterNode;
};

#endif
