/***************************************************************************
                          kxmleditorpart.h  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORPART_H
#define KXMLEDITORPART_H

#include <kparts/part.h>
#include <kparts/browserextension.h>

#include <qdom.h>

#include "kxe_treeview.h"

class QTabWidget;
class KXE_ViewElement;
class KXE_ViewProcInstr;
class DlgSearch;
class DlgConfiguration;
class QMultiLineEdit;
class KAction;
class KToolBarPopupAction;
class KXmlEditorComboAction;
class KXMLEditorPartIfaceReadOnly; // DCOP interface

/** This is the KPart of KXMLEditor. */
class KXMLEditorPart : public KParts::ReadWritePart
{
		Q_OBJECT

	public:
		/** Creates the actions, the view (widgets) and changes to "begin state". */
		KXMLEditorPart( bool fReadWrite, QWidget * pParent, const char * pszName );
		virtual ~KXMLEditorPart();

		/** Changes the behaviour of this part to readonly or readwrite. */
		virtual void setReadWrite( bool fReadWrite = true );

		/** Returns the selected XML object's path or an empty string, if no object is selected. */
		QString getSelectedPath() const { return m_pViewTree->getSelectedPath(); }

		/**
		 * Reimplemented from @ref KParts::KReadWritePart::setModified.
		 *
		 * Alters the window caption according to the given flag and
		 * calls the base functionality.
		 */
		virtual void setModified( bool fModified );

	public slots:

		/**
		 * Reimplemented from @ref KParts::KReadWritePart::setModified.
		 */
		virtual void setModified() { setModified(true); }

		/** displays search dialog and finds string in this tree view */
		void slotEditFind();
		/** finds next occurence of string in this tree view */
		void slotEditFindNext();
		/** deselects currently selected item */
		void slotEditDeselect();
		/** Selects the selected item's parent item. */
		void slotViewNodeUp() { m_pViewTree->slotViewNodeUp(); }
		/** Expands the selected tree item's subtree. */
		void slotViewExpNode() { m_pViewTree->slotViewExpNode(-1); }
		/** Expands the selected tree item's subtree to the given level. */
		void slotViewExpNode( int nLevel ) { m_pViewTree->slotViewExpNode(nLevel); }
		/** Collapses the selected tree item's subtree. */
		void slotViewColNode() { m_pViewTree->slotViewColNode(0); }
		/** Collapses the selected tree item's subtree to the given level. */
		void slotViewColNode( int nLevel ) { m_pViewTree->slotViewColNode(nLevel); }
		/** Insert XML element into document */
		void slotXmlElementInsert();
		/** Edit XML element */
		void slotXmlElementEdit();
		/** Delete XML element */
		void slotXmlElementDelete();
		/** Insert proc.instruction into document */
		void slotXmlProcInstrInsert();
		/** Edit proc.instruction */
		void slotXmlProcInstrEdit();
		/** Delete proc.instruction */
		void slotXmlProcInstrDelete();
		/* Insert charcter data */
		void slotXmlCharDataInsert();
		/* Edit charcter data */
		void slotXmlCharDataEdit();
		/* Delete charcter data */
		void slotXmlCharDataDelete();
		/** toggles bookmark on the selected item */
		void slotBookmarksToggle();
		/** searches for the previous bookmarked item */
		void slotBookmarksPrev() { m_pViewTree->slotBookmarksPrev(); }
		/** searches for the next bookmarked item */
		void slotBookmarksNext() { m_pViewTree->slotBookmarksNext(); }
		/** shows configuration dialog (@ref OptionsDialog) */
		void slotConfigure();

		void slotPathSelected( const QString & szPath );
		void slotPathClear();


	protected:
		/** Opens the file @ref KParts::ReadOnlyPart::m_file. */
		virtual bool openFile();
		/** Saves the file @ref KParts::ReadOnlyPart::m_file. */
		virtual bool saveFile();

		// the actions
		KAction * m_pActEditFind;
		KAction * m_pActEditFindNext;
		KAction * m_pActEditDeselect;
		KAction * m_pActViewNodeUp;
		KToolBarPopupAction * m_pActViewExpNode;
		KToolBarPopupAction * m_pActViewColNode;
		KAction * m_pActBookmarksToggle;
		KAction * m_pActBookmarksPrev;
		KAction * m_pActBookmarksNext;
		KXmlEditorComboAction * m_pActPathCombo;

		/** the document */
		QDomDocument * m_pDoc;

	protected slots:
		void started();
		void completed();
		void canceled();
		/** enables/disables actions depending on the given XML element and changes views  */
		void slotSelectionChanged( const QDomElement & );
		/** enables/disables actions and changes views */
		void slotSelectionChanged( const QDomCharacterData & );
		/** enables/disables actions and changes views */
		void slotSelectionChanged( const QDomProcessingInstruction & );
		/** saves the configuration to the config file */
		void slotConfigurationChanged() const;

	private:
		/** this view displays the XML-document's tree structure */
		KXE_TreeView * m_pViewTree;
		/** the tab widget, contains: m_pViewElement, m_pViewContents */
		QTabWidget * m_pTabWidget;
		/** widget to display XML element */
		KXE_ViewElement * m_pViewElement;
		/** edit widget for contents */
		QMultiLineEdit * m_pViewContents;
		/** widget to display a proc.instr. */
		KXE_ViewProcInstr * m_pViewProcInstr;
		/** the search dialog, used for find action */
		DlgSearch * m_pDlgSearch;
		/** the configuration dialog */
		DlgConfiguration * m_pDlgConfiguration;

	protected:
		/** DCOP object having access to XML document. It may by NULL if no DCOP inteface is provided
		* or read only privided by @ref KXMLEditorPartReadOnlyIface or full read-write @ref KXMLEditorPartIface .
		*/
		KXMLEditorPartIfaceReadOnly * m_pDCOPIface;

};



/**
 * The browser extension for our part (@ref KXMLEditorPart).
 */
class KXMLEditorBrowserExtension : public KParts::BrowserExtension
{
		Q_OBJECT

		friend class KXMLEditorPart;

	public:
		KXMLEditorBrowserExtension( KXMLEditorPart * pParent, const char * pszName = "KXMLEditorBrowserExtension" ) : KParts::BrowserExtension( pParent, pszName ) {}
		virtual ~KXMLEditorBrowserExtension() {}
};

#endif
