/***************************************************************************
                          kxe_viewelement.cpp  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxe_viewelement.h"
#include "kxe_viewattributes.h"

#include <qmultilinedit.h>
#include <qdom.h>

#include "qdom_add.h"

KXE_ViewElement::KXE_ViewElement( QWidget * pParent, const char * pszName )
	: QSplitter( Qt::Vertical, pParent, pszName )
{
	m_pViewAttributes = new KXE_ViewAttributes( 0, 2, this, "table of element attributes");

	m_pViewPlainXML = new QMultiLineEdit( this, "plain XML" );
	m_pViewPlainXML->setReadOnly(true);
}

void KXE_ViewElement::setReadWrite( bool fReadWrite )
{
	m_pViewAttributes->setReadWrite(fReadWrite);
}

void KXE_ViewElement::slotChange( const QDomElement & element )
{
	// change attribute view
	m_pViewAttributes->slotChange(element);

	// change plain XML view
	m_pViewPlainXML->setText( domTool_save(element) );
}