/***************************************************************************
                          kxe_viewattributes.cpp  -  description
                             -------------------
    begin                : Thu Nov 22 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxe_viewattributes.h"

#include <qdom.h>

#include <kdebug.h>

KXE_ViewAttributes::KXE_ViewAttributes( int iRows, int iCols, QWidget * pParent, const char * pszName )
	: QTable( iRows, iCols, pParent, pszName )
{
}

void KXE_ViewAttributes::setReadWrite( bool fReadWrite )
{
	// TODO
}

void KXE_ViewAttributes::contentsMousePressEvent( QMouseEvent * pEvent )
{
	if ( pEvent->button() == QMouseEvent::RightButton )
	{
		QPoint vp = contentsToViewport( pEvent->pos() );
		// TODO implement context menu (in this class!)
		// emit sigRightButtonPressed(viewport()->mapToGlobal(vp));

		return;
	}

	QTable::contentsMousePressEvent(pEvent);
}

void KXE_ViewAttributes::slotChange( const QDomElement & element )
{
	QDomNamedNodeMap list = element.attributes();

	uint iLength = list.length();
	if ( iLength > 0 )
	{
		setNumRows( iLength );
		for ( uint iRow = 0; iRow < iLength; iRow++ )
		{
			QDomNode node = list.item(iRow);
			if ( node.isAttr() )
			{
				setText( iRow, 0, node.toAttr().name() );
				setText( iRow, 1, node.toAttr().value() );
				adjustRow( iRow );
			}
			else
				kdDebug() << "KXE_ViewAttributes::slotChange: node is not an attribute (but should be)" << endl;
		}
	}
}
