/***************************************************************************
                          kxe_treeview.h  -  description
                             -------------------
    begin                : Thu Sep 20 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXE_TREEVIEW_H
#define KXE_TREEVIEW_H

#include <klistview.h>

class DlgSearch;
class DlgConfiguration;

class QDomDocument;
class QDomNode;
class QDomElement;
class QDomCharacterData;
class QDomProcessingInstruction;

class QMouseEvent;
class KXMLGUIClient;
class KXE_TreeViewItem;

/**
 * This is a listview, which displays the XML tree structure.
 * @short shows XML tree
 */
class KXE_TreeView : public KListView
{
		Q_OBJECT

	public:
		KXE_TreeView( KXMLGUIClient * pGUIClient, QWidget * pParent = 0, const char * pszName = 0 );

		/** Changes the behaviour of this view to readonly or readwrite. */
		void setReadWrite( bool fReadWrite );

		/** Selects the given item. */
		void selectItem( KXE_TreeViewItem * const pItem );
		/** Selects the item corresponding to the given node.
		 *  Returns true on success, false otherwise. */
		bool selectNode( const QDomNode & node );

		/** Returns the a pointer to the selected items node or a null pointer (if no item is selected). */
		QDomNode * getSelectedNode() const;
		/** Returns the selected items path or an empty string, if no item is selected. */
		QString getSelectedPath() const;
		/** Returns true, if this tree view contains bookmarked tree items and false otherwise. */
		bool containsBookmarkedItems() const { return (m_nBookmarkedItems>0); }

	public slots:

		// configuration slots
		//////////////////////////////////////////////////////////////

		/**
		 * Sets the root elements decorated/not decorated, depending on the given parameter.
		 * Changes the display mode for XML elements.
		 * Enables/Disables drag'n'drop depending on the given parameter.
		 */
		void slotConfigurationChanged( const DlgConfiguration * const pNewConfiguration );

		// action slots
		//////////////////////////////////////////////////////////////

		/** deselects currently selected item */
		void slotEditDeselect();
		/** Selects the selected item's parent item. */
		void slotViewNodeUp();
		/** Expands the selected tree item's subtree to the given level (see @ref KXE_TreeViewItem::expandSubTree). */
		void slotViewExpNode( int nLevel );
		/** Collapses the selected tree item's subtree to the given level (see @ref KXE_TreeViewItem::collapseSubTree). */
		void slotViewColNode( int nLevel );
		/** toggles bookmark on the selected item */
		void slotBookmarksToggle();
		/** searches for the next bookmarked item */
		void slotBookmarksPrev();
		/** searches for the previous bookmarked item */
		void slotBookmarksNext();

		// update slots
		//////////////////////////////////////////////////////////////

		/**
		 * Creates new item(s) to the given node (and its child nodes)
		 * and inserts it (or them) in the tree.
		 */
		void slotUpdateNodeCreated( const QDomNode & node );
		/** Changes the item corresponding to the given node. */
		void slotUpdateNodeChanged( const QDomNode & node );
		/** Removes the item corresponding to the given node. */
		void slotUpdateNodeDeleted( const QDomNode & node );
		/** Clears the whole tree. */
		void slotUpdateClear();

	signals:
		/** emitted, when an XML element item is selected */
		void sigSelectionChanged( const QDomElement & );
		/** emitted, when an XML Content item is selected */
		void sigSelectionChanged( const QDomCharacterData & );
		/** emitted, when an XML proc.instr. item is selected */
		void sigSelectionChanged( const QDomProcessingInstruction & );
		/**
		 * Signals the change of bookmark status.
		 * true -  item(s) bookmarked
		 * false - no item bookmarked
		 */
		void sigNewBookmarkStatus( bool fStatus );

	protected:
		/** if RMB shows the popupmenu corresponding to the selected item */
		void contentsMousePressEvent( QMouseEvent * );

		/** Finds the corresponding treeview item to the given node. */
		KXE_TreeViewItem * findCorrespondingItem( const QDomNode & node );

		/** the GUI client, needed for the popupmenus */
		KXMLGUIClient * m_pGUIClient;
		/** number of bookmarked items */
		unsigned int m_nBookmarkedItems;

	protected slots:
		/** Checks, which type of item was selected an emits the corresponding signal. */
		void slotSelectionChanged( QListViewItem * );
};

#endif
