/***************************************************************************
                          dlgxmlelement.h  -  description
                             -------------------
    begin                : Mit Apr 17 2002
    copyright            : (C) 2002 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGXMLELEMENT_H
#define DLGXMLELEMENT_H

#include "dlgxmlelementbase.h"
#include "qdom.h"

class DlgXMLElement : public DlgXMLElementBase
{
		Q_OBJECT

	public:
		DlgXMLElement( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

	public slots:
		/**
		 * To be used for editing the given XML element, therefore
		 * hides the "Where to insert" widgets.
		 * Updates the given element with the data entered by the user (if OK was pressed).
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( QDomElement & domElement );
		/**
		 * To be used for inserting the given XML element as root element,
		 * therefore hides the "Where to insert" widgets.
		 * If OK was pressed, the given element is updated with the entered
		 * data and gets set as the given XML documents root element.
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( QDomDocument & domDoc, QDomElement & domNewElement );
		/**
		 * To be used for inserting the given XML element as child element
		 * of the given parent element.
		 * If OK was pressed, the given element is updated with the entered
		 * data and gets set as a child element of the given parent element.
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( QDomElement & domParentElement, QDomElement & domNewElement );

		/**
		 * Fills the dialogs widgets with the data from the given XML element.
		 */
		void fillDialog( const QDomElement & domElement );
		/**
		 * Updates the given element with the data entered in the dialogs widgets.
		 */
		void fillElement( QDomElement & domElement );

	protected slots:
		/**
		 * Don't use this function directly, it's for internal use only.
		 * Use one of the other @ref DlgXMLElement::exec functions instead.
		 */
		int exec();
		/**
		 * Called, when the tag name in the edit line @ref DlgXMLElementBase::m_pEditTagName
		 * is changed.
		 * Disables the OK button, if the given string is empty.
		 */
		void slotTagNameChanged( const QString & szNewTagName );

};

#endif