/***************************************************************************
                          dlgsearch.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGSEARCH_H
#define DLGSEARCH_H

#include "dlgsearchbase.h"

#include <qlineedit.h>
#include <qcheckbox.h>

/**
 * Dialog for input information from user
 * about searching in XML document
 */
// TODO add possibility to search backwards
class DlgSearch : public DlgSearchBase
{
		Q_OBJECT

	public:
		DlgSearch( QWidget * pParent, const char * pszName = 0, bool bModal = true );

		QString getSearchString() const { return m_pEditSearchedString->text(); }
		bool getMatchCase() const { return m_pCheckBoxMatchCase->isChecked(); }
		bool getInElementNames() const { return m_pCheckBoxElementNames->isChecked(); }
		bool getInAttributeNames() const { return m_pCheckBoxAttributeNames->isChecked(); }
		bool getInAttributeValues() const { return m_pCheckBoxAttributeValues->isChecked(); }
		bool getInContents() const { return m_pCheckBoxContents->isChecked(); }

	protected:
		/** Enables/Disables the "Find"-button. */
		void toggleAcceptButton();

	protected slots:
		/** Called when text in edit line is changed */
		void slotTextChanged( const QString & );
		/** Called on a change of the "find in" checkbuttons. */
		void slotFindInChanged();


};

#endif
