/***************************************************************************
                          dlgconfiguration.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DLGCONFIGURATION_H
#define DLGCONFIGURATION_H

#include <kdialogbase.h>

#include "confpage_xml.h"
#include "confpage_treeview.h"
#include "confpage_targzext.h"
#include "confpage_specchars.h"

#include <qstringlist.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qspinbox.h>

class KConfig;

/**
 * Applications configuration dialog.
 * @author Olaf Hartig
 */
class DlgConfiguration : public KDialogBase
{
		Q_OBJECT

	public:

		enum enXmlParser
		{
			parserSAX2 = 0, parserDOM
		};

		DlgConfiguration( QWidget * pParent, const char * pszName = 0, bool bModal = true );

		/** Reads the configuration from the given config file. */
		void readConfiguration( KConfig * );
		/** Saves the current configuration to the given config file. */
		void saveConfiguration( KConfig * ) const;

		bool getTreeViewRootDecorated() const { return m_pPageTreeView->m_pCheckBoxRootDecorated->isChecked(); }
		unsigned int getTreeViewExpandToLevel() const { return m_pPageTreeView->m_pSpinBoxExpandLevel->value(); }
		bool getTreeViewEnableDragDrop() const { return m_pPageTreeView->m_pCheckBoxEnableDragDrop->isChecked(); }
		int getTreeViewElemDisplayMode() const;

		QStrList getListOfTarGzExtensions() const;

		QStrList getListOfSpecCharacters() const;

		enXmlParser getXmlParser() const { return ( m_pPageXML->m_pRadioBtnParserSAX2->isChecked() ? parserSAX2 : parserDOM ); }
		bool getXmlDontConvertAmpersand() const { return m_pPageXML->m_pCheckBoxDontConvertAmpersand->isChecked(); }
		bool getXmlAppendCRLF() const { return m_pPageXML->m_pCheckBoxAppendCRLF->isChecked(); }

	protected:

		ConfPage_XML * m_pPageXML;
		ConfPage_TreeView * m_pPageTreeView;
		ConfPage_TarGzExt * m_pPageTarGzExt;
		ConfPage_SpecChars * m_pPageSpecChars;

	protected slots:

		/** Called when user presses Apply button */
		void slotApply();

		/** Called when user presses OK button */
		void slotOk();

		/** Called, when Delete button clicked */
		void slotDeleteExtension();

		/** Called, when New button clicked */
		void slotNewExtension();

		/** Called, when text in edit line changed  */
		void slotExtensionChanged( const QString & );

		/** Called, when user select item in list of extensions */
		void slotListTarGzExtSelChanged();

		/** Called, when text in edit line changed  */
		void slotSpecCharacterChanged( const QString & );

		/** Called, when New button clicked */
		void slotNewSpecCharacter();

		/** Called, when Delete button clicked */
		void slotDeleteSpecCharacter();

		/** Called, when user select item in list of extensions */
		void slotListSpecCharsSelChanged();

	signals:

		/** Emited, when user press Apply or Ok buttons */
		void configurationChanged( const DlgConfiguration * const pNewConfiguration );
};

#endif
