/***************************************************************************
                          dlgconfiguration.cpp  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dlgconfiguration.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kconfig.h>

DlgConfiguration::DlgConfiguration( QWidget * pParent, const char * pszName, bool bModal )
	: KDialogBase( IconList,
	               i18n("Configure"),
	               Apply | Ok | Cancel | Help,
	               Ok,
	               pParent,
	               pszName,
	               bModal,
	               true )
{
	QFrame * pTmpFrame;
	QVBoxLayout * pTmpLayout;

	// setting up XML page
	pTmpFrame = addPage( i18n("XML"),
	                     i18n("XML properties"),
	                     KGlobal::instance()->iconLoader()->loadIcon("kxmleditor", KIcon::NoGroup, KIcon::SizeMedium) );
	m_pPageXML = new ConfPage_XML( pTmpFrame );
	pTmpLayout = new QVBoxLayout( pTmpFrame, 0, spacingHint() );
	pTmpLayout->addWidget( m_pPageXML );
	m_pPageXML->m_pRadioBtnParserSAX2->setEnabled(false); // TODO remove, when a SAX2 parser is written and should be used

	// setting up treeview page
	pTmpFrame = addPage( i18n("Tree View"),
	                     i18n("Tree View properties"),
	                     KGlobal::instance()->iconLoader()->loadIcon("view_tree", KIcon::NoGroup, KIcon::SizeMedium) );
	m_pPageTreeView = new ConfPage_TreeView( pTmpFrame );
	pTmpLayout = new QVBoxLayout( pTmpFrame, 0, spacingHint() );
	pTmpLayout->addWidget( m_pPageTreeView );
	m_pPageTreeView->m_pCheckBoxEnableDragDrop->setEnabled(false); // TODO remove, when a drag&drop is implemented and should be used

	// setting up tar.gz-extensions page
	pTmpFrame = addPage( i18n("TarGz Extensions"),
	                     i18n("Define TarGz file extensions"),
	                     KGlobal::instance()->iconLoader()->loadIcon("filetypes", KIcon::NoGroup, KIcon::SizeMedium) );
	m_pPageTarGzExt = new ConfPage_TarGzExt( pTmpFrame );
	pTmpLayout = new QVBoxLayout( pTmpFrame, 0, spacingHint() );
	pTmpLayout->addWidget( m_pPageTarGzExt );
	connect( m_pPageTarGzExt->m_pListView, SIGNAL(selectionChanged()), this, SLOT(slotListTarGzExtSelChanged()) );
	connect( m_pPageTarGzExt->m_pEditExtension, SIGNAL(textChanged(const QString&)), this, SLOT(slotExtensionChanged(const QString&)) );
	connect( m_pPageTarGzExt->m_pBtnNew, SIGNAL(clicked()), this, SLOT(slotNewExtension()) );
	connect( m_pPageTarGzExt->m_pBtnDelete, SIGNAL(clicked()), this, SLOT(slotDeleteExtension()) );

	// setting up special characters page
	pTmpFrame =  addPage( i18n("Spec. Characters"),
	                      i18n("Define Special Characters List"),
	                      KGlobal::instance()->iconLoader()->loadIcon("charset", KIcon::NoGroup, KIcon::SizeMedium) );
	m_pPageSpecChars = new ConfPage_SpecChars( pTmpFrame);
	pTmpLayout = new QVBoxLayout( pTmpFrame, 0, spacingHint() );
	pTmpLayout->addWidget( m_pPageSpecChars );
	connect( m_pPageSpecChars->m_pListView, SIGNAL(selectionChanged()), this, SLOT(slotListSpecCharsSelChanged()) );
	connect( m_pPageSpecChars->m_pEditSpecCharacter, SIGNAL(textChanged(const QString&)), this, SLOT(slotSpecCharacterChanged(const QString&)) );
	connect( m_pPageSpecChars->m_pBtnNew, SIGNAL(clicked()), this, SLOT(slotNewSpecCharacter()) );
	connect( m_pPageSpecChars->m_pBtnDelete, SIGNAL(clicked()), this, SLOT(slotDeleteSpecCharacter()) );

}


void DlgConfiguration::slotExtensionChanged( const QString & szText )
{
	if ( m_pPageTarGzExt->m_pListView->selectedItem() )
		m_pPageTarGzExt->m_pListView->selectedItem()->setText( 0, szText );
}

void DlgConfiguration::slotNewExtension()
{
	QListViewItem * pItem = new QListViewItem( m_pPageTarGzExt->m_pListView, "" );
	m_pPageTarGzExt->m_pListView->setCurrentItem( pItem );
	m_pPageTarGzExt->m_pListView->setSelected( pItem, true );

	if ( m_pPageTarGzExt->m_pListView->selectedItem() )
	{
		m_pPageTarGzExt->m_pEditExtension->setEnabled(true);
		m_pPageTarGzExt->m_pLabelExtension->setEnabled(true);
		m_pPageTarGzExt->m_pEditExtension->setFocus();
	}
}

void DlgConfiguration::slotDeleteExtension()
{
	QListViewItem * pDelItem = m_pPageTarGzExt->m_pListView->selectedItem();
	if ( pDelItem )
	{
		QListViewItem * pNextItem = pDelItem->itemAbove();
		if ( ! pNextItem )
			pNextItem = pDelItem->itemBelow();

		m_pPageTarGzExt->m_pEditExtension->clear();
		m_pPageTarGzExt->m_pEditExtension->setEnabled(false);
		m_pPageTarGzExt->m_pLabelExtension->setEnabled(false);

		m_pPageTarGzExt->m_pListView->takeItem( pDelItem );
		delete pDelItem;

		if ( pNextItem )
			m_pPageTarGzExt->m_pListView->setSelected( pNextItem, true );
	}
}

void DlgConfiguration::slotListTarGzExtSelChanged()
{
	if ( m_pPageTarGzExt->m_pListView->selectedItem() )
	{
		m_pPageTarGzExt->m_pEditExtension->setText( m_pPageTarGzExt->m_pListView->selectedItem()->text(0) );
		m_pPageTarGzExt->m_pListView->setEnabled(true);
		m_pPageTarGzExt->m_pLabelExtension->setEnabled(true);
		m_pPageTarGzExt->m_pEditExtension->setEnabled(true);
	}
}

void DlgConfiguration::slotSpecCharacterChanged( const QString & szText )
{
	if ( m_pPageSpecChars->m_pListView->selectedItem() )
		m_pPageSpecChars->m_pListView->selectedItem()->setText( 0, szText );
}

void DlgConfiguration::slotNewSpecCharacter()
{
	QListViewItem * pItem = new QListViewItem( m_pPageSpecChars->m_pListView, "" );
	m_pPageSpecChars->m_pListView->setCurrentItem( pItem );
	m_pPageSpecChars->m_pListView->setSelected( pItem, true );

	if ( m_pPageSpecChars->m_pListView->selectedItem() )
	{
		m_pPageSpecChars->m_pEditSpecCharacter->setEnabled(true);
		m_pPageSpecChars->m_pLabelSpecCharacter->setEnabled(true);
		m_pPageSpecChars->m_pEditSpecCharacter->setFocus();
	}
}

void DlgConfiguration::slotDeleteSpecCharacter()
{
	QListViewItem * pDelItem = m_pPageSpecChars->m_pListView->selectedItem();
	if ( pDelItem )
	{
		QListViewItem * pNextItem = pDelItem->itemAbove();
		if ( ! pNextItem )
			pNextItem = pDelItem->itemBelow();

		m_pPageSpecChars->m_pEditSpecCharacter->clear();
		m_pPageSpecChars->m_pEditSpecCharacter->setEnabled(false);
		m_pPageSpecChars->m_pLabelSpecCharacter->setEnabled(false);

		m_pPageSpecChars->m_pListView->takeItem( pDelItem );
		delete pDelItem;

		if ( pNextItem )
			m_pPageSpecChars->m_pListView->setSelected( pNextItem, true );
	}
}

void DlgConfiguration::slotListSpecCharsSelChanged()
{
	if ( m_pPageSpecChars->m_pListView->selectedItem() )
	{
		m_pPageSpecChars->m_pEditSpecCharacter->setText( m_pPageSpecChars->m_pListView->selectedItem()->text(0) );
		m_pPageSpecChars->m_pListView->setEnabled(true);
		m_pPageSpecChars->m_pLabelSpecCharacter->setEnabled(true);
		m_pPageSpecChars->m_pEditSpecCharacter->setEnabled(true);
	}
}

void DlgConfiguration::slotOk()
{
	slotApply();
	accept();
}

void DlgConfiguration::slotApply()
{
	emit configurationChanged( this );
}

void DlgConfiguration::readConfiguration( KConfig * pConfig )
{
	pConfig->setGroup("XML");
	if ( pConfig->readNumEntry("Parser", 0) == 0 )
	{
		m_pPageXML->m_pRadioBtnParserSAX2->setChecked(true);
		m_pPageXML->m_pRadioBtnParserDOM->setChecked(false);
		m_pPageXML->m_pCheckBoxDontConvertAmpersand->setEnabled(true);
		m_pPageXML->m_pCheckBoxAppendCRLF->setEnabled(true);
	}
	else
	{
		m_pPageXML->m_pRadioBtnParserSAX2->setChecked(false);
		m_pPageXML->m_pRadioBtnParserDOM->setChecked(true);
		m_pPageXML->m_pCheckBoxDontConvertAmpersand->setEnabled(false);
		m_pPageXML->m_pCheckBoxAppendCRLF->setEnabled(false);
	}
	m_pPageXML->m_pCheckBoxDontConvertAmpersand->setChecked( pConfig->readBoolEntry("Don't convert ampersand", false) );
	m_pPageXML->m_pCheckBoxAppendCRLF->setChecked( pConfig->readBoolEntry("Append CR LF", false) );

	pConfig->setGroup("Tree View");
	m_pPageTreeView->m_pSpinBoxExpandLevel->setValue( pConfig->readNumEntry("Expand to level", 5) );
	m_pPageTreeView->m_pCheckBoxRootDecorated->setChecked( pConfig->readBoolEntry("Root decorated", false) );
	m_pPageTreeView->m_pCheckBoxEnableDragDrop->setChecked( pConfig->readBoolEntry("Enable DnD", true) );
	switch (pConfig->readNumEntry("Element display mode", 0))
	{
		case 0:
			m_pPageTreeView->m_pBtnEDM_NoAttributes->setChecked(true);
			break;
		case 1:
			m_pPageTreeView->m_pBtnEDM_NamesOnly->setChecked(true);
			break;
		case 2:
			m_pPageTreeView->m_pBtnEDM_NamesValues->setChecked(true);
			break;
		default:
			m_pPageTreeView->m_pBtnEDM_NoAttributes->setChecked(true);
	}

	pConfig->setGroup("TarGz Extensions");
	QStrList strListOfTarGzExtensions;
	pConfig->readListEntry("Extensions", strListOfTarGzExtensions);
	QString szExtension;
	for ( szExtension = strListOfTarGzExtensions.first();
	      szExtension != 0;
	      szExtension = strListOfTarGzExtensions.next() )
		static_cast <void> ( new QListViewItem( m_pPageTarGzExt->m_pListView, szExtension ) );

	pConfig->setGroup("Spec. Characters");
	QStrList strListOfSpecCharacters;
	pConfig->readListEntry("Characters", strListOfSpecCharacters);
	QString strSpecChar;
	for( strSpecChar = strListOfSpecCharacters.first();
	     strSpecChar != 0;
	     strSpecChar = strListOfSpecCharacters.next() )
		static_cast <void> ( new QListViewItem( m_pPageSpecChars->m_pListView, strSpecChar ) );

}

void DlgConfiguration::saveConfiguration( KConfig * pConfig ) const
{
	pConfig->setGroup("XML");
	pConfig->writeEntry("Parser", getXmlParser() );
	pConfig->writeEntry("Don't convert ampersand", getXmlDontConvertAmpersand() );
	pConfig->writeEntry("Append CR LF", getXmlAppendCRLF() );

	pConfig->setGroup("Tree View");
	pConfig->writeEntry("Root decorated", getTreeViewRootDecorated() );
	pConfig->writeEntry("Expand to level", getTreeViewExpandToLevel() );
	pConfig->writeEntry("Enable DnD", getTreeViewEnableDragDrop() );
	pConfig->writeEntry("Element display mode", getTreeViewElemDisplayMode() );

	pConfig->setGroup("TarGz Extensions");
	pConfig->writeEntry("Extensions", getListOfTarGzExtensions() );

	pConfig->setGroup("Spec. Characters");
	pConfig->writeEntry("Characters", getListOfSpecCharacters() );

	pConfig->sync();
}

int DlgConfiguration::getTreeViewElemDisplayMode() const
{
	if ( m_pPageTreeView->m_pBtnEDM_NoAttributes->isChecked() )
		return 0;
	else if ( m_pPageTreeView->m_pBtnEDM_NamesOnly->isChecked() )
		return 1;
	else if ( m_pPageTreeView->m_pBtnEDM_NamesValues->isChecked() )
		return 2;
	else
		return 0;
}

QStrList DlgConfiguration::getListOfTarGzExtensions() const
{
	QStrList list;

	QListViewItem * pTarGzItem = m_pPageTarGzExt->m_pListView->firstChild();
	while (pTarGzItem)
	{
		list.append( pTarGzItem->text(0) );
		pTarGzItem = pTarGzItem->nextSibling();
	}

	return list;
}

QStrList DlgConfiguration::getListOfSpecCharacters() const
{
	QStrList list;
	QListViewItem * pSpecCharsItem = m_pPageSpecChars->m_pListView->firstChild();
	while (pSpecCharsItem)
	{
		list.append( pSpecCharsItem->text(0) );
		pSpecCharsItem = pSpecCharsItem->nextSibling();
	}
	return list;
}
